/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.manager;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BankInterestManager {
    private final EzEconomyPlugin plugin;
    private int taskId = -1;

    public BankInterestManager(EzEconomyPlugin plugin) {
        this.plugin = plugin;
    }

    public void start(long intervalTicks) {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
        this.taskId = new BukkitRunnable(){

            public void run() {
                BankInterestManager.this.payInterestToAll();
            }
        }.runTaskTimer((Plugin)this.plugin, intervalTicks, intervalTicks).getTaskId();
    }

    public void stop() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
            this.taskId = -1;
        }
    }

    private void payInterestToAll() {
        ConfigurationSection section;
        StorageProvider storage = this.plugin.getStorageOrWarn();
        if (storage == null) {
            return;
        }
        FileConfiguration config = this.plugin.getConfig();
        boolean multiEnabled = config.getBoolean("multi-currency.enabled", false);
        Set currencies = multiEnabled ? ((section = config.getConfigurationSection("multi-currency.currencies")) != null ? section.getKeys(false) : Collections.singleton("dollar")) : Collections.singleton("dollar");
        for (String currency : currencies) {
            for (String bank : storage.getBanks()) {
                double bankBalance = storage.getBankBalance(bank, currency);
                Set<UUID> members = storage.getBankMembers(bank);
                if (members == null || members.isEmpty()) continue;
                double grossInterest = this.calculateInterest(bankBalance);
                double perMemberInterest = grossInterest / (double)members.size();
                for (UUID uuid : members) {
                    OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
                    if (!(perMemberInterest > 0.0)) continue;
                    storage.setBalance(uuid, currency, storage.getBalance(uuid, currency) + perMemberInterest);
                    if (!player.isOnline()) continue;
                    player.getPlayer().sendMessage("You received " + this.plugin.getEconomy().format(perMemberInterest) + " " + currency + " interest from bank '" + bank + "'");
                }
            }
        }
    }

    private double calculateInterest(double balance) {
        return (double)Math.round(balance * 0.01 * 100.0) / 100.0;
    }
}

