/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.command;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import com.skyblockexp.ezeconomy.core.MessageProvider;
import com.skyblockexp.ezeconomy.gui.BalanceGui;
import com.skyblockexp.ezeconomy.util.NumberUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class EcoCommand
implements CommandExecutor {
    private final EzEconomyPlugin plugin;

    public EcoCommand(EzEconomyPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        MessageProvider messages = this.plugin.getMessageProvider();
        if (!sender.hasPermission("ezeconomy.eco")) {
            sender.sendMessage(messages.color(messages.get("no_permission")));
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("gui")) {
            Map currencySection;
            if (!(sender instanceof Player)) {
                sender.sendMessage(messages.color("&cOnly players can use this command."));
                return true;
            }
            Player player = (Player)sender;
            StorageProvider storage = this.plugin.getStorageOrWarn();
            if (storage == null) {
                player.sendMessage(messages.color("&cStorage provider unavailable. Check server logs."));
                return true;
            }
            FileConfiguration config = this.plugin.getConfig();
            HashMap<String, Double> currencies = new HashMap<String, Double>();
            Map map = currencySection = config.getConfigurationSection("multi-currency.currencies") != null ? config.getConfigurationSection("multi-currency.currencies").getValues(false) : Collections.emptyMap();
            if (config.getBoolean("multi-currency.enabled", false) && !currencySection.isEmpty()) {
                for (String currency : currencySection.keySet()) {
                    double balance = storage.getBalance(player.getUniqueId(), currency);
                    currencies.put(currency, balance);
                }
            } else {
                String currency = this.plugin.getDefaultCurrency();
                double balance = storage.getBalance(player.getUniqueId(), currency);
                currencies.put(currency, balance);
            }
            HashMap<String, Double> banks = new HashMap<String, Double>();
            for (String bank : storage.getBanks()) {
                if (!storage.isBankMember(bank, player.getUniqueId())) continue;
                if (config.getBoolean("multi-currency.enabled", false) && !currencySection.isEmpty()) {
                    for (String currency : currencySection.keySet()) {
                        double bankBalance = storage.getBankBalance(bank, currency);
                        banks.put(bank + " (" + currency + ")", bankBalance);
                    }
                    continue;
                }
                String currency = this.plugin.getDefaultCurrency();
                double bankBalance = storage.getBankBalance(bank, currency);
                banks.put(bank, bankBalance);
            }
            BalanceGui.open(player, currencies, banks);
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage(messages.color(messages.get("usage_eco")));
            return true;
        }
        String action = args[0].toLowerCase();
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        double amount = NumberUtil.parseAmount(args[2]);
        if (Double.isNaN(amount)) {
            sender.sendMessage(messages.color(messages.get("invalid_amount")));
            return true;
        }
        switch (action) {
            case "give": {
                this.plugin.getEconomy().depositPlayer(target, amount);
                sender.sendMessage(messages.color(messages.get("paid", Map.of("player", target.getName(), "amount", this.plugin.getEconomy().format(amount)))));
                break;
            }
            case "take": {
                this.plugin.getEconomy().withdrawPlayer(target, amount);
                sender.sendMessage(messages.color(messages.get("withdrew", Map.of("name", target.getName(), "amount", this.plugin.getEconomy().format(amount)))));
                break;
            }
            case "set": {
                StorageProvider storage = this.plugin.getStorageOrWarn();
                if (storage == null) {
                    sender.sendMessage(messages.color("&cStorage provider unavailable. Check server logs."));
                    return true;
                }
                storage.setBalance(target.getUniqueId(), this.plugin.getDefaultCurrency(), amount);
                sender.sendMessage(messages.color(messages.get("set", Map.of("player", target.getName(), "balance", this.plugin.getEconomy().format(amount)))));
                break;
            }
            default: {
                sender.sendMessage(messages.color(messages.get("unknown_action")));
            }
        }
        return true;
    }
}

