/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.command;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import com.skyblockexp.ezeconomy.core.MessageProvider;
import com.skyblockexp.ezeconomy.manager.CurrencyPreferenceManager;
import java.util.Collections;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BalanceCommand
implements CommandExecutor {
    private final EzEconomyPlugin plugin;

    public BalanceCommand(EzEconomyPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Map currencies;
        MessageProvider messages = this.plugin.getMessageProvider();
        CurrencyPreferenceManager preferenceManager = this.plugin.getCurrencyPreferenceManager();
        StorageProvider storage = (StorageProvider)this.plugin.getEconomy().getStorage();
        Map map = currencies = this.plugin.getConfig().getConfigurationSection("multi-currency.currencies") != null ? this.plugin.getConfig().getConfigurationSection("multi-currency.currencies").getValues(false) : Collections.emptyMap();
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(messages.get("only_players"));
                return true;
            }
            Player player = (Player)sender;
            String currency = preferenceManager.getPreferredCurrency(player.getUniqueId());
            double balance = storage != null ? storage.getBalance(player.getUniqueId(), currency) : this.plugin.getEconomy().getBalance((OfflinePlayer)player);
            sender.sendMessage(messages.get("your_balance", Map.of("balance", this.plugin.getEconomy().format(balance), "currency", currency)));
            return true;
        }
        if (args.length == 1) {
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
            if (target.hasPlayedBefore() || target.isOnline()) {
                if (!sender.hasPermission("ezeconomy.balance.others")) {
                    sender.sendMessage(messages.get("no_permission_others_balance"));
                    return true;
                }
                String currency = preferenceManager.getPreferredCurrency(target.getUniqueId());
                double balance = storage != null ? storage.getBalance(target.getUniqueId(), currency) : this.plugin.getEconomy().getBalance(target);
                sender.sendMessage(messages.get("others_balance", Map.of("player", target.getName(), "balance", this.plugin.getEconomy().format(balance), "currency", currency)));
                return true;
            }
            if (!(sender instanceof Player)) {
                sender.sendMessage(messages.get("only_players"));
                return true;
            }
            Player player = (Player)sender;
            String currency = args[0].toLowerCase();
            if (!currencies.containsKey(currency)) {
                sender.sendMessage(messages.get("unknown_currency", Map.of("currency", currency)));
                return true;
            }
            double balance = storage != null ? storage.getBalance(player.getUniqueId(), currency) : this.plugin.getEconomy().getBalance((OfflinePlayer)player);
            sender.sendMessage(messages.get("your_balance", Map.of("balance", this.plugin.getEconomy().format(balance), "currency", currency)));
            return true;
        }
        if (args.length == 2) {
            if (!sender.hasPermission("ezeconomy.balance.others")) {
                sender.sendMessage(messages.get("no_permission_others_balance"));
                return true;
            }
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
            String currency = args[1].toLowerCase();
            if (!currencies.containsKey(currency)) {
                sender.sendMessage(messages.get("unknown_currency", Map.of("currency", currency)));
                return true;
            }
            double balance = storage != null ? storage.getBalance(target.getUniqueId(), currency) : this.plugin.getEconomy().getBalance(target);
            sender.sendMessage(messages.get("others_balance", Map.of("player", target.getName(), "balance", this.plugin.getEconomy().format(balance), "currency", currency)));
            return true;
        }
        sender.sendMessage(messages.get("usage_balance"));
        return true;
    }
}

