/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.api;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.api.storage.models.Transaction;
import com.skyblockexp.ezeconomy.dto.PlayerBalanceDTO;
import com.skyblockexp.ezeconomy.service.BankEconomyService;
import com.skyblockexp.ezeconomy.service.CurrencyService;
import com.skyblockexp.ezeconomy.service.PlayerEconomyService;
import com.skyblockexp.ezeconomy.storage.TransferResult;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class EzEconomyAPI {
    public static final String VERSION = "2.0.0";
    private final PlayerEconomyService playerService;
    private final BankEconomyService bankService;
    private final CurrencyService currencyService;

    public EzEconomyAPI(StorageProvider storageProvider) {
        this.playerService = new PlayerEconomyService(storageProvider);
        this.bankService = new BankEconomyService(storageProvider);
        this.currencyService = new CurrencyService(storageProvider);
    }

    public String getVersion() {
        return VERSION;
    }

    public PlayerBalanceDTO getBalance(UUID uuid, String currency) {
        double balance = this.playerService.getBalance(uuid, currency);
        return new PlayerBalanceDTO(uuid, currency, balance);
    }

    public boolean deposit(UUID uuid, String currency, double amount) {
        return this.playerService.deposit(uuid, currency, amount);
    }

    public boolean withdraw(UUID uuid, String currency, double amount) {
        return this.playerService.withdraw(uuid, currency, amount);
    }

    public List<Transaction> getTransactions(UUID uuid, String currency) {
        return this.playerService.getTransactions(uuid, currency);
    }

    public Map<UUID, Double> getAllBalances(String currency) {
        return this.playerService.getAllBalances(currency);
    }

    public TransferResult transfer(UUID fromUuid, UUID toUuid, String currency, double amount) {
        return this.playerService.transfer(fromUuid, toUuid, currency, amount);
    }

    public TransferResult transfer(UUID fromUuid, UUID toUuid, String currency, double debitAmount, double creditAmount) {
        return this.playerService.transfer(fromUuid, toUuid, currency, debitAmount, creditAmount);
    }

    public boolean createBank(String name, UUID owner) {
        return this.bankService.createBank(name, owner);
    }

    public boolean deleteBank(String name) {
        return this.bankService.deleteBank(name);
    }

    public boolean bankExists(String name) {
        return this.bankService.bankExists(name);
    }

    public double getBankBalance(String name, String currency) {
        return this.bankService.getBankBalance(name, currency);
    }

    public void setBankBalance(String name, String currency, double amount) {
        this.bankService.setBankBalance(name, currency, amount);
    }

    public boolean tryWithdrawBank(String name, String currency, double amount) {
        return this.bankService.tryWithdrawBank(name, currency, amount);
    }

    public void depositBank(String name, String currency, double amount) {
        this.bankService.depositBank(name, currency, amount);
    }

    public Set<String> getBanks() {
        return this.bankService.getBanks();
    }

    public boolean isBankOwner(String name, UUID uuid) {
        return this.bankService.isBankOwner(name, uuid);
    }

    public boolean isBankMember(String name, UUID uuid) {
        return this.bankService.isBankMember(name, uuid);
    }

    public boolean addBankMember(String name, UUID uuid) {
        return this.bankService.addBankMember(name, uuid);
    }

    public boolean removeBankMember(String name, UUID uuid) {
        return this.bankService.removeBankMember(name, uuid);
    }

    public Set<UUID> getBankMembers(String name) {
        return this.bankService.getBankMembers(name);
    }

    public String getDefaultCurrency() {
        return this.currencyService.getDefaultCurrency();
    }

    public Set<String> getAvailableCurrencies() {
        return this.currencyService.getAvailableCurrencies();
    }

    public boolean isCurrencyEnabled(String currency) {
        return this.currencyService.isCurrencyEnabled(currency);
    }
}

