/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.service;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.api.storage.models.Transaction;
import com.skyblockexp.ezeconomy.storage.TransferResult;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PlayerEconomyService {
    private final StorageProvider storageProvider;

    public PlayerEconomyService(StorageProvider storageProvider) {
        this.storageProvider = storageProvider;
    }

    public double getBalance(UUID uuid, String currency) {
        return this.storageProvider.getBalance(uuid, currency);
    }

    public boolean deposit(UUID uuid, String currency, double amount) {
        this.storageProvider.deposit(uuid, currency, amount);
        return true;
    }

    public boolean withdraw(UUID uuid, String currency, double amount) {
        return this.storageProvider.tryWithdraw(uuid, currency, amount);
    }

    public List<Transaction> getTransactions(UUID uuid, String currency) {
        return this.storageProvider.getTransactions(uuid, currency);
    }

    public Map<UUID, Double> getAllBalances(String currency) {
        return this.storageProvider.getAllBalances(currency);
    }

    public TransferResult transfer(UUID fromUuid, UUID toUuid, String currency, double amount) {
        return this.storageProvider.transfer(fromUuid, toUuid, currency, amount);
    }

    public TransferResult transfer(UUID fromUuid, UUID toUuid, String currency, double debitAmount, double creditAmount) {
        return this.storageProvider.transfer(fromUuid, toUuid, currency, debitAmount, creditAmount);
    }
}

