/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.service;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import com.skyblockexp.ezeconomy.manager.CurrencyManager;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;

public class CurrencyService {
    private final StorageProvider storageProvider;

    public CurrencyService(StorageProvider storageProvider) {
        this.storageProvider = storageProvider;
    }

    public String getDefaultCurrency() {
        EzEconomyPlugin plugin;
        CurrencyManager cm;
        StorageProvider storageProvider = this.storageProvider;
        if (storageProvider instanceof EzEconomyPlugin && (cm = (plugin = (EzEconomyPlugin)((Object)storageProvider)).getCurrencyManager()) != null) {
            return cm.getDefaultCurrency();
        }
        return "dollar";
    }

    public Set<String> getAvailableCurrencies() {
        EzEconomyPlugin plugin;
        FileConfiguration config;
        StorageProvider storageProvider = this.storageProvider;
        if (storageProvider instanceof EzEconomyPlugin && (config = (plugin = (EzEconomyPlugin)((Object)storageProvider)).getConfig()).isConfigurationSection("multi-currency.currencies")) {
            return config.getConfigurationSection("multi-currency.currencies").getKeys(false);
        }
        return Set.of("dollar");
    }

    public boolean isCurrencyEnabled(String currency) {
        return this.getAvailableCurrencies().contains(currency);
    }
}

