/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.service;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import java.util.Set;
import java.util.UUID;

public class BankEconomyService {
    private final StorageProvider storageProvider;

    public BankEconomyService(StorageProvider storageProvider) {
        this.storageProvider = storageProvider;
    }

    public boolean createBank(String name, UUID owner) {
        return this.storageProvider.createBank(name, owner);
    }

    public boolean deleteBank(String name) {
        return this.storageProvider.deleteBank(name);
    }

    public boolean bankExists(String name) {
        return this.storageProvider.bankExists(name);
    }

    public double getBankBalance(String name, String currency) {
        return this.storageProvider.getBankBalance(name, currency);
    }

    public void setBankBalance(String name, String currency, double amount) {
        this.storageProvider.setBankBalance(name, currency, amount);
    }

    public boolean tryWithdrawBank(String name, String currency, double amount) {
        return this.storageProvider.tryWithdrawBank(name, currency, amount);
    }

    public void depositBank(String name, String currency, double amount) {
        this.storageProvider.depositBank(name, currency, amount);
    }

    public Set<String> getBanks() {
        return this.storageProvider.getBanks();
    }

    public boolean isBankOwner(String name, UUID uuid) {
        return this.storageProvider.isBankOwner(name, uuid);
    }

    public boolean isBankMember(String name, UUID uuid) {
        return this.storageProvider.isBankMember(name, uuid);
    }

    public boolean addBankMember(String name, UUID uuid) {
        return this.storageProvider.addBankMember(name, uuid);
    }

    public boolean removeBankMember(String name, UUID uuid) {
        return this.storageProvider.removeBankMember(name, uuid);
    }

    public Set<UUID> getBankMembers(String name) {
        return this.storageProvider.getBankMembers(name);
    }
}

