/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.command;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import com.skyblockexp.ezeconomy.core.MessageProvider;
import java.util.Map;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class BankCommand
implements CommandExecutor {
    private final EzEconomyPlugin plugin;

    public BankCommand(EzEconomyPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        MessageProvider messages = this.plugin.getMessageProvider();
        if (args.length < 1) {
            sender.sendMessage(messages.color(messages.get("usage_bank")));
            return true;
        }
        String sub = args[0].toLowerCase();
        String currency = "dollar";
        switch (sub) {
            case "create": {
                if (!sender.hasPermission("ezeconomy.bank.create") && !sender.hasPermission("ezeconomy.bank.admin")) {
                    sender.sendMessage(messages.color(messages.get("no_permission")));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(messages.color(messages.get("usage_bank")));
                    return true;
                }
                if (!(sender instanceof OfflinePlayer)) {
                    sender.sendMessage(messages.color(messages.get("only_players")));
                    return true;
                }
                String name = args[1];
                OfflinePlayer owner = (OfflinePlayer)sender;
                EconomyResponse createResponse = this.plugin.getEconomy().createBank(name, owner);
                if (this.handleEconomyFailure(sender, createResponse, messages)) {
                    return true;
                }
                sender.sendMessage(messages.color(messages.get("bank_created", Map.of("name", name))));
                break;
            }
            case "delete": {
                if (!sender.hasPermission("ezeconomy.bank.delete") && !sender.hasPermission("ezeconomy.bank.admin")) {
                    sender.sendMessage(messages.color(messages.get("no_permission")));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(messages.color(messages.get("usage_bank")));
                    return true;
                }
                EconomyResponse deleteResponse = this.plugin.getEconomy().deleteBank(args[1]);
                if (this.handleEconomyFailure(sender, deleteResponse, messages)) {
                    return true;
                }
                sender.sendMessage(messages.color(messages.get("bank_deleted", Map.of("name", args[1]))));
                break;
            }
            case "balance": {
                EconomyResponse balanceResponse;
                if (!sender.hasPermission("ezeconomy.bank.balance") && !sender.hasPermission("ezeconomy.bank.admin")) {
                    sender.sendMessage(messages.color(messages.get("no_permission")));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(messages.color(messages.get("usage_bank")));
                    return true;
                }
                if (args.length >= 3) {
                    currency = args[2];
                }
                if (this.handleEconomyFailure(sender, balanceResponse = this.plugin.getEconomy().bankBalance(args[1], currency), messages)) {
                    return true;
                }
                double bal = balanceResponse.balance;
                sender.sendMessage(messages.color(messages.get("bank_balance", Map.of("name", args[1], "balance", this.plugin.getEconomy().format(bal), "currency", currency))));
                break;
            }
            case "deposit": {
                EconomyResponse depositResponse;
                double dep;
                if (!sender.hasPermission("ezeconomy.bank.deposit") && !sender.hasPermission("ezeconomy.bank.admin")) {
                    sender.sendMessage(messages.color(messages.get("no_permission")));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage(messages.color(messages.get("usage_bank")));
                    return true;
                }
                try {
                    dep = Double.parseDouble(args[2]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(messages.color(messages.get("invalid_amount")));
                    return true;
                }
                if (dep <= 0.0) {
                    sender.sendMessage(messages.color(messages.get("must_be_positive")));
                    return true;
                }
                if (args.length >= 4) {
                    currency = args[3];
                }
                if (this.handleEconomyFailure(sender, depositResponse = this.plugin.getEconomy().bankDeposit(args[1], currency, dep), messages)) {
                    return true;
                }
                sender.sendMessage(messages.color(messages.get("deposited", Map.of("amount", this.plugin.getEconomy().format(dep), "name", args[1], "currency", currency))));
                break;
            }
            case "withdraw": {
                EconomyResponse withdrawResponse;
                double wd;
                if (!sender.hasPermission("ezeconomy.bank.withdraw") && !sender.hasPermission("ezeconomy.bank.admin")) {
                    sender.sendMessage(messages.color(messages.get("no_permission")));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage(messages.color(messages.get("usage_bank")));
                    return true;
                }
                try {
                    wd = Double.parseDouble(args[2]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(messages.color(messages.get("invalid_amount")));
                    return true;
                }
                if (wd <= 0.0) {
                    sender.sendMessage(messages.color(messages.get("must_be_positive")));
                    return true;
                }
                if (args.length >= 4) {
                    currency = args[3];
                }
                if (this.handleEconomyFailure(sender, withdrawResponse = this.plugin.getEconomy().bankWithdraw(args[1], currency, wd), messages)) {
                    return true;
                }
                sender.sendMessage(messages.color(messages.get("withdrew", Map.of("amount", this.plugin.getEconomy().format(wd), "name", args[1], "currency", currency))));
                break;
            }
            case "addmember": {
                if (!sender.hasPermission("ezeconomy.bank.addmember") && !sender.hasPermission("ezeconomy.bank.admin")) {
                    sender.sendMessage(messages.color(messages.get("no_permission")));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage(messages.color(messages.get("usage_bank")));
                    return true;
                }
                StorageProvider storageAdd = this.plugin.getStorageOrWarn();
                if (storageAdd == null) {
                    sender.sendMessage(messages.color("&cStorage provider unavailable. Check server logs."));
                    return true;
                }
                OfflinePlayer add = Bukkit.getOfflinePlayer((String)args[2]);
                storageAdd.addBankMember(args[1], add.getUniqueId());
                sender.sendMessage(messages.color(messages.get("added_member", Map.of("player", add.getName(), "name", args[1]))));
                break;
            }
            case "removemember": {
                if (!sender.hasPermission("ezeconomy.bank.removemember") && !sender.hasPermission("ezeconomy.bank.admin")) {
                    sender.sendMessage(messages.color(messages.get("no_permission")));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage(messages.color(messages.get("usage_bank")));
                    return true;
                }
                StorageProvider storageRemove = this.plugin.getStorageOrWarn();
                if (storageRemove == null) {
                    sender.sendMessage(messages.color("&cStorage provider unavailable. Check server logs."));
                    return true;
                }
                OfflinePlayer rem = Bukkit.getOfflinePlayer((String)args[2]);
                storageRemove.removeBankMember(args[1], rem.getUniqueId());
                sender.sendMessage(messages.color(messages.get("removed_member", Map.of("player", rem.getName(), "name", args[1]))));
                break;
            }
            case "info": {
                StorageProvider storageInfo;
                if (!sender.hasPermission("ezeconomy.bank.info") && !sender.hasPermission("ezeconomy.bank.admin")) {
                    sender.sendMessage(messages.color(messages.get("no_permission")));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(messages.color(messages.get("usage_bank")));
                    return true;
                }
                if (args.length >= 3) {
                    currency = args[2];
                }
                if ((storageInfo = this.plugin.getStorageOrWarn()) == null) {
                    sender.sendMessage(messages.color("&cStorage provider unavailable. Check server logs."));
                    return true;
                }
                EconomyResponse infoBalanceResponse = this.plugin.getEconomy().bankBalance(args[1], currency);
                if (this.handleEconomyFailure(sender, infoBalanceResponse, messages)) {
                    return true;
                }
                double infoBalance = infoBalanceResponse.balance;
                sender.sendMessage(messages.color(messages.get("bank_info", Map.of("name", args[1], "balance", this.plugin.getEconomy().format(infoBalance), "currency", currency, "members", String.valueOf(storageInfo.getBankMembers(args[1]).size())))));
                break;
            }
            default: {
                sender.sendMessage(messages.color(messages.get("unknown_subcommand")));
            }
        }
        return true;
    }

    private boolean handleEconomyFailure(CommandSender sender, EconomyResponse response, MessageProvider messages) {
        if (response == null || response.type == EconomyResponse.ResponseType.FAILURE || response.type == EconomyResponse.ResponseType.NOT_IMPLEMENTED) {
            String message;
            String string = message = response == null ? "Bank operation failed." : response.errorMessage;
            if (message == null || message.isBlank()) {
                message = "Bank operation failed.";
            }
            sender.sendMessage(messages.color(message));
            return true;
        }
        return false;
    }
}

