/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.storage;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.file.YamlConfiguration;

public class MySQLStorageProvider
implements StorageProvider {
    private final EzEconomyPlugin plugin;
    private Connection connection;
    private String table;
    private final Object lock = new Object();
    private final YamlConfiguration dbConfig;

    public MySQLStorageProvider(EzEconomyPlugin plugin, YamlConfiguration dbConfig) {
        this.plugin = plugin;
        this.dbConfig = dbConfig;
        if (dbConfig == null) {
            throw new IllegalArgumentException("MySQL config is missing!");
        }
        String host = dbConfig.getString("mysql.host");
        int port = dbConfig.getInt("mysql.port");
        String database = dbConfig.getString("mysql.database");
        String username = dbConfig.getString("mysql.username");
        String password = dbConfig.getString("mysql.password");
        this.table = dbConfig.getString("mysql.table", "balances");
        try {
            this.connection = DriverManager.getConnection("jdbc:mysql://" + host + ":" + port + "/" + database, username, password);
            Statement stmt = this.connection.createStatement();
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.table + "` (uuid VARCHAR(36), currency VARCHAR(32), balance DOUBLE, PRIMARY KEY (uuid, currency))");
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS banks (name VARCHAR(64), currency VARCHAR(32), balance DOUBLE, PRIMARY KEY (name, currency))");
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS bank_members (bank VARCHAR(64), uuid VARCHAR(36), owner BOOLEAN, PRIMARY KEY (bank, uuid))");
        }
        catch (SQLException e) {
            plugin.getLogger().severe("MySQL connection failed: " + e.getMessage());
            throw new RuntimeException("Failed to initialize MySQLStorageProvider", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getBalance(UUID uuid, String currency) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT balance FROM `" + this.table + "` WHERE uuid=? AND currency=?");
                ps.setString(1, uuid.toString());
                ps.setString(2, currency);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    return rs.getDouble(1);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] MySQL getBalance failed for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("[EzEconomy] Unexpected error in getBalance for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBalance(UUID uuid, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("REPLACE INTO `" + this.table + "` (uuid, currency, balance) VALUES (?, ?, ?)");
                ps.setString(1, uuid.toString());
                ps.setString(2, currency);
                ps.setDouble(3, amount);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] MySQL setBalance failed for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("[EzEconomy] Unexpected error in setBalance for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryWithdraw(UUID uuid, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("UPDATE `" + this.table + "` SET balance = balance - ? WHERE uuid=? AND currency=? AND balance >= ?");
                ps.setDouble(1, amount);
                ps.setString(2, uuid.toString());
                ps.setString(3, currency);
                ps.setDouble(4, amount);
                return ps.executeUpdate() > 0;
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] MySQL tryWithdraw failed for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("[EzEconomy] Unexpected error in tryWithdraw for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deposit(UUID uuid, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("INSERT INTO `" + this.table + "` (uuid, currency, balance) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE balance = balance + VALUES(balance)");
                ps.setString(1, uuid.toString());
                ps.setString(2, currency);
                ps.setDouble(3, amount);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] MySQL deposit failed for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("[EzEconomy] Unexpected error in deposit for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] MySQL shutdown failed: " + e.getMessage());
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("[EzEconomy] Unexpected error on shutdown: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UUID, Double> getAllBalances(String currency) {
        Object object = this.lock;
        synchronized (object) {
            ConcurrentHashMap<UUID, Double> map = new ConcurrentHashMap<UUID, Double>();
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT uuid, balance FROM `" + this.table + "` WHERE currency=?");
                ps.setString(1, currency);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    try {
                        UUID uuid = UUID.fromString(rs.getString(1));
                        double bal = rs.getDouble(2);
                        map.put(uuid, bal);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] MySQL getAllBalances failed (" + currency + "): " + e.getMessage());
            }
            return map;
        }
    }

    private void ensureBankTables() {
        try {
            Statement stmt = this.connection.createStatement();
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS banks (name VARCHAR(64), currency VARCHAR(32), balance DOUBLE, PRIMARY KEY (name, currency))");
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS bank_members (bank VARCHAR(64), uuid VARCHAR(36), owner BOOLEAN, PRIMARY KEY (bank, uuid))");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("[EzEconomy] MySQL ensureBankTables failed: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createBank(String name, UUID owner) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureBankTables();
            try {
                PreparedStatement ps = this.connection.prepareStatement("INSERT INTO banks (name, currency, balance) VALUES (?, ?, 0.0)");
                ps.setString(1, name);
                ps.setString(2, "dollar");
                ps.executeUpdate();
                ps = this.connection.prepareStatement("INSERT INTO bank_members (bank, uuid, owner) VALUES (?, ?, ?)");
                ps.setString(1, name);
                ps.setString(2, owner.toString());
                ps.setBoolean(3, true);
                ps.executeUpdate();
                return true;
            }
            catch (SQLException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteBank(String name) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureBankTables();
            try {
                PreparedStatement ps = this.connection.prepareStatement("DELETE FROM banks WHERE name=?");
                ps.setString(1, name);
                int affected = ps.executeUpdate();
                ps = this.connection.prepareStatement("DELETE FROM bank_members WHERE bank=?");
                ps.setString(1, name);
                ps.executeUpdate();
                return affected > 0;
            }
            catch (SQLException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bankExists(String name) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureBankTables();
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT name FROM banks WHERE name=?");
                ps.setString(1, name);
                ResultSet rs = ps.executeQuery();
                return rs.next();
            }
            catch (SQLException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getBankBalance(String name, String currency) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureBankTables();
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT balance FROM banks WHERE name=? AND currency=?");
                ps.setString(1, name);
                ps.setString(2, currency);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    return rs.getDouble(1);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBankBalance(String name, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureBankTables();
            try {
                PreparedStatement ps = this.connection.prepareStatement("REPLACE INTO banks (name, currency, balance) VALUES (?, ?, ?)");
                ps.setString(1, name);
                ps.setString(2, currency);
                ps.setDouble(3, amount);
                ps.executeUpdate();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryWithdrawBank(String name, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureBankTables();
            try {
                PreparedStatement ps = this.connection.prepareStatement("UPDATE banks SET balance = balance - ? WHERE name=? AND currency=? AND balance >= ?");
                ps.setDouble(1, amount);
                ps.setString(2, name);
                ps.setString(3, currency);
                ps.setDouble(4, amount);
                return ps.executeUpdate() > 0;
            }
            catch (SQLException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void depositBank(String name, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureBankTables();
            try {
                PreparedStatement ps = this.connection.prepareStatement("INSERT INTO banks (name, currency, balance) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE balance = balance + VALUES(balance)");
                ps.setString(1, name);
                ps.setString(2, currency);
                ps.setDouble(3, amount);
                ps.executeUpdate();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getBanks() {
        Object object = this.lock;
        synchronized (object) {
            this.ensureBankTables();
            ConcurrentHashMap.KeySetView set = ConcurrentHashMap.newKeySet();
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT name FROM banks");
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    set.add(rs.getString(1));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBankOwner(String name, UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureBankTables();
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT owner FROM bank_members WHERE bank=? AND uuid=?");
                ps.setString(1, name);
                ps.setString(2, uuid.toString());
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    return rs.getBoolean(1);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBankMember(String name, UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureBankTables();
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT uuid FROM bank_members WHERE bank=? AND uuid=?");
                ps.setString(1, name);
                ps.setString(2, uuid.toString());
                ResultSet rs = ps.executeQuery();
                return rs.next();
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addBankMember(String name, UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureBankTables();
            if (this.isBankMember(name, uuid)) {
                return false;
            }
            try {
                PreparedStatement ps = this.connection.prepareStatement("INSERT INTO bank_members (bank, uuid, owner) VALUES (?, ?, ?)");
                ps.setString(1, name);
                ps.setString(2, uuid.toString());
                ps.setBoolean(3, false);
                ps.executeUpdate();
                return true;
            }
            catch (SQLException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeBankMember(String name, UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureBankTables();
            try {
                PreparedStatement ps = this.connection.prepareStatement("DELETE FROM bank_members WHERE bank=? AND uuid=?");
                ps.setString(1, name);
                ps.setString(2, uuid.toString());
                int affected = ps.executeUpdate();
                return affected > 0;
            }
            catch (SQLException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<UUID> getBankMembers(String name) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureBankTables();
            ConcurrentHashMap.KeySetView set = ConcurrentHashMap.newKeySet();
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT uuid FROM bank_members WHERE bank=?");
                ps.setString(1, name);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    try {
                        set.add(UUID.fromString(rs.getString(1)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return set;
        }
    }
}

