/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.storage;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.UpdateOptions;
import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.api.storage.exceptions.StorageInitException;
import com.skyblockexp.ezeconomy.api.storage.exceptions.StorageLoadException;
import com.skyblockexp.ezeconomy.api.storage.exceptions.StorageSaveException;
import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bukkit.configuration.file.YamlConfiguration;

public class MongoDBStorageProvider
implements StorageProvider {
    private final EzEconomyPlugin plugin;
    private MongoClient mongoClient;
    private MongoDatabase database;
    private MongoCollection<Document> balances;
    private MongoCollection<Document> banks;
    private final Object lock = new Object();
    private final YamlConfiguration dbConfig;

    public void init() throws StorageInitException {
        if (this.mongoClient == null || this.database == null) {
            throw new StorageInitException("MongoDB not initialized.");
        }
    }

    public void load() throws StorageLoadException {
    }

    public void save() throws StorageSaveException {
    }

    public void close() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    public String toString() {
        return "MongoDBStorageProvider{database='" + (this.database != null ? this.database.getName() : "null") + "'}";
    }

    public MongoDBStorageProvider(EzEconomyPlugin plugin, YamlConfiguration dbConfig) {
        this.plugin = plugin;
        this.dbConfig = dbConfig;
        if (dbConfig == null) {
            throw new IllegalArgumentException("MongoDB config is missing!");
        }
        String uri = dbConfig.getString("mongodb.uri", "mongodb://localhost:27017");
        String dbName = dbConfig.getString("mongodb.database", "ezeconomy");
        String collection = dbConfig.getString("mongodb.collection", "balances");
        try {
            this.mongoClient = MongoClients.create((String)uri);
            this.database = this.mongoClient.getDatabase(dbName);
            this.balances = this.database.getCollection(collection);
            this.banks = this.database.getCollection(dbConfig.getString("mongodb.banksCollection", "banks"));
            this.balances.createIndex((Bson)new Document("uuid", (Object)1).append("currency", (Object)1));
            this.banks.createIndex((Bson)new Document("name", (Object)1), new IndexOptions().unique(true));
        }
        catch (Exception e) {
            plugin.getLogger().severe("MongoDB connection failed: " + e.getMessage());
            throw new RuntimeException("Failed to initialize MongoDBStorageProvider", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getBalance(UUID uuid, String currency) {
        Object object = this.lock;
        synchronized (object) {
            Document doc = (Document)this.balances.find((Bson)new Document("uuid", (Object)uuid.toString()).append("currency", (Object)currency)).first();
            if (doc != null) {
                return doc.getDouble((Object)"balance");
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBalance(UUID uuid, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            Document query = new Document("uuid", (Object)uuid.toString()).append("currency", (Object)currency);
            Document update = new Document("$set", (Object)new Document("balance", (Object)amount));
            this.balances.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryWithdraw(UUID uuid, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            Document query = new Document("uuid", (Object)uuid.toString()).append("currency", (Object)currency).append("balance", (Object)new Document("$gte", (Object)amount));
            Document update = new Document("$inc", (Object)new Document("balance", (Object)(-amount)));
            Document updated = (Document)this.balances.findOneAndUpdate((Bson)query, (Bson)update);
            return updated != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deposit(UUID uuid, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            Document query = new Document("uuid", (Object)uuid.toString()).append("currency", (Object)currency);
            Document update = new Document("$inc", (Object)new Document("balance", (Object)amount));
            this.balances.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UUID, Double> getAllBalances(String currency) {
        HashMap<UUID, Double> map = new HashMap<UUID, Double>();
        Object object = this.lock;
        synchronized (object) {
            for (Document doc : this.balances.find((Bson)new Document("currency", (Object)currency))) {
                map.put(UUID.fromString(doc.getString((Object)"uuid")), doc.getDouble((Object)"balance"));
            }
        }
        return map;
    }

    @Override
    public void shutdown() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createBank(String name, UUID owner) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bankExists(name)) {
                return false;
            }
            Document doc = new Document("name", (Object)name).append("owner", (Object)owner.toString()).append("members", new ArrayList<String>(List.of(owner.toString()))).append("balances", (Object)new Document());
            this.banks.insertOne((Object)doc);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteBank(String name) {
        Object object = this.lock;
        synchronized (object) {
            return this.banks.deleteOne((Bson)new Document("name", (Object)name)).getDeletedCount() > 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bankExists(String name) {
        Object object = this.lock;
        synchronized (object) {
            return this.banks.find((Bson)new Document("name", (Object)name)).first() != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getBankBalance(String name, String currency) {
        Object object = this.lock;
        synchronized (object) {
            Document balancesDoc;
            Document doc = (Document)this.banks.find((Bson)new Document("name", (Object)name)).first();
            if (doc != null && (balancesDoc = (Document)doc.get((Object)"balances", Document.class)) != null && balancesDoc.containsKey((Object)currency)) {
                return balancesDoc.getDouble((Object)currency);
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBankBalance(String name, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            this.banks.updateOne((Bson)new Document("name", (Object)name), (Bson)new Document("$set", (Object)new Document("balances." + currency, (Object)amount)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryWithdrawBank(String name, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            Document query = new Document("name", (Object)name).append("balances." + currency, (Object)new Document("$gte", (Object)amount));
            Document update = new Document("$inc", (Object)new Document("balances." + currency, (Object)(-amount)));
            Document updated = (Document)this.banks.findOneAndUpdate((Bson)query, (Bson)update);
            return updated != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void depositBank(String name, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            this.banks.updateOne((Bson)new Document("name", (Object)name), (Bson)new Document("$inc", (Object)new Document("balances." + currency, (Object)amount)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getBanks() {
        HashSet<String> set = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            for (Document doc : this.banks.find()) {
                set.add(doc.getString((Object)"name"));
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBankOwner(String name, UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            Document doc = (Document)this.banks.find((Bson)new Document("name", (Object)name)).first();
            return doc != null && uuid.toString().equals(doc.getString((Object)"owner"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBankMember(String name, UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            Document doc = (Document)this.banks.find((Bson)new Document("name", (Object)name)).first();
            if (doc != null) {
                List members = doc.getList((Object)"members", String.class, List.of());
                return members.contains(uuid.toString());
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addBankMember(String name, UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            Document doc = (Document)this.banks.find((Bson)new Document("name", (Object)name)).first();
            if (doc == null) {
                return false;
            }
            List members = doc.getList((Object)"members", String.class, new ArrayList());
            if (members.contains(uuid.toString())) {
                return false;
            }
            members.add(uuid.toString());
            this.banks.updateOne((Bson)new Document("name", (Object)name), (Bson)new Document("$set", (Object)new Document("members", (Object)members)));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeBankMember(String name, UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            Document doc = (Document)this.banks.find((Bson)new Document("name", (Object)name)).first();
            if (doc == null) {
                return false;
            }
            List members = doc.getList((Object)"members", String.class, new ArrayList());
            if (!members.contains(uuid.toString())) {
                return false;
            }
            members.remove(uuid.toString());
            this.banks.updateOne((Bson)new Document("name", (Object)name), (Bson)new Document("$set", (Object)new Document("members", (Object)members)));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<UUID> getBankMembers(String name) {
        HashSet<UUID> set = new HashSet<UUID>();
        Object object = this.lock;
        synchronized (object) {
            Document doc = (Document)this.banks.find((Bson)new Document("name", (Object)name)).first();
            if (doc != null) {
                List members = doc.getList((Object)"members", String.class, List.of());
                for (String s : members) {
                    try {
                        set.add(UUID.fromString(s));
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return set;
    }
}

