/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.manager;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import com.skyblockexp.ezeconomy.storage.DailyRewardStorage;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class DailyRewardManager {
    private final EzEconomyPlugin plugin;
    private final DailyRewardStorage storage;

    public DailyRewardManager(EzEconomyPlugin plugin) {
        this.plugin = plugin;
        this.storage = new DailyRewardStorage(plugin);
    }

    public void handleJoin(Player player) {
        if (!this.isEnabled()) {
            return;
        }
        if (!player.hasPermission(this.getPermission())) {
            return;
        }
        StorageProvider storageProvider = this.plugin.getStorageOrWarn();
        if (storageProvider == null) {
            this.debug("Storage provider unavailable; skipping daily reward.");
            return;
        }
        double amount = this.plugin.getConfig().getDouble("daily-reward.amount", 0.0);
        if (amount <= 0.0) {
            this.debug("Daily reward amount is <= 0; skipping reward.");
            return;
        }
        long cooldownMillis = this.getCooldownMillis();
        long now = System.currentTimeMillis();
        long lastReward = this.storage.getLastReward(player.getUniqueId());
        if (lastReward > 0L && now - lastReward < cooldownMillis) {
            this.debug("Cooldown active for " + player.getName() + ".");
            return;
        }
        if (lastReward > now) {
            this.debug("Last reward timestamp is in the future for " + player.getName() + ".");
            return;
        }
        String currency = this.resolveCurrency(this.plugin.getConfig().getString("daily-reward.currency", "default"));
        storageProvider.deposit(player.getUniqueId(), currency, amount);
        this.storage.setLastReward(player.getUniqueId(), now);
        this.sendMessage(player, amount, currency);
        this.playSound(player);
        this.debug("Rewarded " + player.getName() + " " + amount + " " + currency + ".");
    }

    public void resetReward(UUID uuid) {
        this.storage.reset(uuid);
    }

    private boolean isEnabled() {
        return this.plugin.getConfig().getBoolean("daily-reward.enabled", false);
    }

    private String getPermission() {
        return this.plugin.getConfig().getString("daily-reward.permission", "ezeconomy.daily");
    }

    private long getCooldownMillis() {
        long hours = this.plugin.getConfig().getLong("daily-reward.cooldown-hours", 24L);
        if (hours < 0L) {
            hours = 0L;
        }
        return hours * 60L * 60L * 1000L;
    }

    private String resolveCurrency(String configuredCurrency) {
        String fallback = this.plugin.getDefaultCurrency();
        if (configuredCurrency == null || configuredCurrency.trim().isEmpty() || configuredCurrency.equalsIgnoreCase("default")) {
            return fallback;
        }
        boolean multiEnabled = this.plugin.getConfig().getBoolean("multi-currency.enabled", false);
        if (!multiEnabled) {
            this.debug("Multi-currency disabled; using default currency.");
            return fallback;
        }
        String trimmed = configuredCurrency.trim();
        if (this.currencyExists(trimmed)) {
            return trimmed;
        }
        String lowered = trimmed.toLowerCase(Locale.ROOT);
        if (this.currencyExists(lowered)) {
            return lowered;
        }
        this.debug("Configured currency '" + configuredCurrency + "' not found; using default.");
        return fallback;
    }

    private boolean currencyExists(String currency) {
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("multi-currency.currencies." + currency);
        return section != null;
    }

    private String resolveCurrencyDisplay(String currency) {
        boolean multiEnabled = this.plugin.getConfig().getBoolean("multi-currency.enabled", false);
        if (!multiEnabled) {
            return currency;
        }
        String display = this.plugin.getConfig().getString("multi-currency.currencies." + currency + ".display");
        return display == null || display.isEmpty() ? currency : display;
    }

    private void sendMessage(Player player, double amount, String currency) {
        String message = this.plugin.getConfig().getString("daily-reward.message", "");
        if (message == null || message.isEmpty()) {
            return;
        }
        String formattedAmount = this.plugin.getEconomy().format(amount);
        String displayCurrency = this.resolveCurrencyDisplay(currency);
        String resolved = message.replace("%amount%", formattedAmount).replace("%currency%", displayCurrency);
        player.sendMessage(this.plugin.getMessageProvider().color(resolved));
    }

    private void playSound(Player player) {
        String soundName = this.plugin.getConfig().getString("daily-reward.sound", "");
        if (soundName == null || soundName.trim().isEmpty()) {
            return;
        }
        try {
            Sound sound = Sound.valueOf((String)soundName.trim().toUpperCase(Locale.ROOT));
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException | NoSuchFieldError e) {
            this.debug("Invalid sound '" + soundName + "' configured for daily reward.");
        }
    }

    private void debug(String message) {
        if (!this.plugin.getConfig().getBoolean("daily-reward.debug", false)) {
            return;
        }
        this.plugin.getLogger().info("[DailyReward] " + message);
    }
}

