/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.core;

import com.skyblockexp.ezeconomy.shaded.net.kyori.adventure.text.Component;
import com.skyblockexp.ezeconomy.shaded.net.kyori.adventure.text.TextComponent;
import com.skyblockexp.ezeconomy.shaded.net.kyori.adventure.text.minimessage.MiniMessage;
import com.skyblockexp.ezeconomy.shaded.net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import com.skyblockexp.ezeconomy.shaded.net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.skyblockexp.ezeconomy.shaded.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import java.util.Map;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;

public class MessageProvider {
    private final FileConfiguration config;
    private final String language;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build();

    public MessageProvider(FileConfiguration config) {
        this.config = Objects.requireNonNull(config, "config");
        String lang = config.getString("language");
        this.language = lang != null && !lang.isEmpty() ? lang : "en";
    }

    public String get(String key) {
        String msg = this.resolveMessage(key);
        return this.format(msg, Map.of());
    }

    public String get(String key, Map<String, String> placeholders) {
        String message = this.resolveMessage(key);
        return this.format(message, placeholders);
    }

    public String color(String message) {
        return this.format(message, Map.of());
    }

    private String resolveMessage(String key) {
        String langKey = "messages." + this.language + "." + key;
        String fallbackKey = "messages." + key;
        String msg = this.config.getString(langKey);
        if (msg == null) {
            msg = this.config.getString(fallbackKey, "\u00a7cMissing message: " + key);
        }
        return msg;
    }

    private String format(String message, Map<String, String> placeholders) {
        String resolved = this.replaceBracedPlaceholders(message, placeholders);
        if (this.containsLegacyFormatting(resolved)) {
            String legacyResolved = this.replaceAnglePlaceholders(resolved, placeholders);
            String translated = ChatColor.translateAlternateColorCodes((char)'&', (String)legacyResolved);
            TextComponent component = this.legacySerializer.deserialize(translated);
            return this.legacySerializer.serialize(component);
        }
        TagResolver resolver = this.buildResolver(placeholders);
        Component component = this.miniMessage.deserialize(resolved, resolver);
        return this.legacySerializer.serialize(component);
    }

    private TagResolver buildResolver(Map<String, String> placeholders) {
        if (placeholders == null || placeholders.isEmpty()) {
            return TagResolver.empty();
        }
        TagResolver.Builder builder = TagResolver.builder();
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            builder.resolver(Placeholder.parsed(entry.getKey(), entry.getValue()));
        }
        return builder.build();
    }

    private String replaceBracedPlaceholders(String message, Map<String, String> placeholders) {
        if (placeholders == null || placeholders.isEmpty() || message == null) {
            return message;
        }
        String resolved = message;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            resolved = resolved.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return resolved;
    }

    private String replaceAnglePlaceholders(String message, Map<String, String> placeholders) {
        if (placeholders == null || placeholders.isEmpty() || message == null) {
            return message;
        }
        String resolved = message;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            resolved = resolved.replace("<" + entry.getKey() + ">", entry.getValue());
        }
        return resolved;
    }

    private boolean containsLegacyFormatting(String message) {
        if (message == null) {
            return false;
        }
        for (int index = 0; index < message.length() - 1; ++index) {
            char code;
            char current = message.charAt(index);
            if (current != '&' && current != '\u00a7' || "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx".indexOf(code = message.charAt(index + 1)) < 0) continue;
            return true;
        }
        return false;
    }
}

