/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.command;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import com.skyblockexp.ezeconomy.core.MessageProvider;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class BaltopCommand
implements CommandExecutor {
    private final EzEconomyPlugin plugin;
    private static final int DEFAULT_TOP = 10;
    private static final int PAGE_SIZE = 10;

    public BaltopCommand(EzEconomyPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        StorageProvider storage;
        int top = 10;
        boolean usePaging = false;
        int page = 1;
        if (args.length == 2 && args[0].equalsIgnoreCase("page")) {
            usePaging = true;
            try {
                page = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (args.length == 1) {
            try {
                top = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((storage = this.plugin.getStorageOrWarn()) == null) {
            sender.sendMessage("\u00a7cStorage provider unavailable. Check server logs.");
            return true;
        }
        Map<UUID, Double> balances = storage.getAllBalances(this.plugin.getDefaultCurrency());
        List sorted = balances.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toList());
        MessageProvider messages = this.plugin.getMessageProvider();
        if (usePaging) {
            int totalEntries = sorted.size();
            int totalPages = (int)Math.ceil((double)totalEntries / 10.0);
            if (totalPages == 0) {
                totalPages = 1;
            }
            if (page <= 0 || page > totalPages) {
                sender.sendMessage(messages.get("baltop_invalid_page", Map.of("page", String.valueOf(page), "total_pages", String.valueOf(totalPages), "page_size", String.valueOf(10))));
                return true;
            }
            sender.sendMessage(messages.get("top_balances_page", Map.of("page", String.valueOf(page), "total_pages", String.valueOf(totalPages), "page_size", String.valueOf(10))));
            int startIndex = (page - 1) * 10;
            int endIndex = Math.min(startIndex + 10, totalEntries);
            sorted = sorted.subList(startIndex, endIndex);
            int rank = startIndex + 1;
            for (Map.Entry entry : sorted) {
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey()));
                sender.sendMessage(messages.get("rank_balance", Map.of("rank", String.valueOf(rank), "player", player.getName(), "balance", this.plugin.getEconomy().format((Double)entry.getValue()))));
                ++rank;
            }
            return true;
        }
        if (top > 0 && sorted.size() > top) {
            sorted = sorted.subList(0, top);
        }
        sender.sendMessage(messages.get("top_balances", Map.of("top", String.valueOf(top))));
        int rank = 1;
        for (Map.Entry entry : sorted) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey()));
            sender.sendMessage(messages.get("rank_balance", Map.of("rank", String.valueOf(rank), "player", player.getName(), "balance", this.plugin.getEconomy().format((Double)entry.getValue()))));
            ++rank;
        }
        return true;
    }
}

