/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.command;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import com.skyblockexp.ezeconomy.core.MessageProvider;
import com.skyblockexp.ezeconomy.manager.CurrencyPreferenceManager;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BalanceCommand
implements CommandExecutor {
    private final EzEconomyPlugin plugin;

    public BalanceCommand(EzEconomyPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        MessageProvider messages = this.plugin.getMessageProvider();
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(messages.get("only_players"));
                return true;
            }
            Player player = (Player)sender;
            CurrencyPreferenceManager preferenceManager = this.plugin.getCurrencyPreferenceManager();
            String currency = preferenceManager.getPreferredCurrency(player.getUniqueId());
            StorageProvider storage = (StorageProvider)this.plugin.getEconomy().getStorage();
            double balance = storage != null ? storage.getBalance(player.getUniqueId(), currency) : this.plugin.getEconomy().getBalance((OfflinePlayer)player);
            sender.sendMessage(messages.get("your_balance", Map.of("balance", this.plugin.getEconomy().format(balance))));
            return true;
        }
        if (args.length == 1) {
            if (!sender.hasPermission("ezeconomy.balance.others")) {
                sender.sendMessage(messages.get("no_permission_others_balance"));
                return true;
            }
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
            CurrencyPreferenceManager preferenceManager = this.plugin.getCurrencyPreferenceManager();
            String currency = preferenceManager.getPreferredCurrency(target.getUniqueId());
            StorageProvider storage = (StorageProvider)this.plugin.getEconomy().getStorage();
            double balance = storage != null ? storage.getBalance(target.getUniqueId(), currency) : this.plugin.getEconomy().getBalance(target);
            sender.sendMessage(messages.get("others_balance", Map.of("player", target.getName(), "balance", this.plugin.getEconomy().format(balance))));
            return true;
        }
        sender.sendMessage(messages.get("usage_balance"));
        return true;
    }
}

