/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.manager;

import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class CurrencyPreferenceManager {
    private static final String PREFERENCES_PATH = "preferences";
    private final EzEconomyPlugin plugin;
    private final File dataFile;
    private final Map<UUID, String> preferences = new ConcurrentHashMap<UUID, String>();
    private YamlConfiguration config;

    public CurrencyPreferenceManager(EzEconomyPlugin plugin) {
        this.plugin = plugin;
        this.dataFile = new File(plugin.getDataFolder(), "currency-preferences.yml");
        this.load();
    }

    public String getPreferredCurrency(UUID uuid) {
        return this.preferences.getOrDefault(uuid, this.getDefaultCurrency());
    }

    public void setPreferredCurrency(UUID uuid, String currency) {
        this.preferences.put(uuid, currency);
        this.persist(uuid, currency);
    }

    public void load() {
        this.config = YamlConfiguration.loadConfiguration((File)this.dataFile);
        ConfigurationSection section = this.config.getConfigurationSection(PREFERENCES_PATH);
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(key);
                String currency = section.getString(key);
                if (currency == null || currency.isBlank()) continue;
                this.preferences.put(uuid, currency.toLowerCase());
            }
            catch (IllegalArgumentException ignored) {
                this.plugin.getLogger().warning("Invalid UUID in currency preferences: " + key);
            }
        }
    }

    public void save() {
        if (this.config == null) {
            this.config = new YamlConfiguration();
        }
        for (Map.Entry<UUID, String> entry : this.preferences.entrySet()) {
            this.config.set("preferences." + String.valueOf(entry.getKey()), (Object)entry.getValue());
        }
        try {
            this.config.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save currency preferences: " + e.getMessage());
        }
    }

    private void persist(UUID uuid, String currency) {
        if (this.config == null) {
            this.config = new YamlConfiguration();
        }
        this.config.set("preferences." + String.valueOf(uuid), (Object)currency);
        try {
            this.config.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save currency preferences: " + e.getMessage());
        }
    }

    private String getDefaultCurrency() {
        FileConfiguration config = this.plugin.getConfig();
        boolean multiEnabled = config.getBoolean("multi-currency.enabled", false);
        return multiEnabled ? config.getString("multi-currency.default", "dollar") : "dollar";
    }
}

