/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.core;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;

public class VaultEconomyImpl
implements Economy {
    private final EzEconomyPlugin plugin;

    public VaultEconomyImpl(EzEconomyPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean hasAccount(OfflinePlayer player) {
        StorageProvider storage = this.getStorageProvider();
        if (storage == null) {
            return false;
        }
        try {
            storage.getBalance(player.getUniqueId(), this.plugin.getDefaultCurrency());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    public Object getStorage() {
        return this.plugin.getStorage();
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return this.hasAccount(player);
    }

    public boolean isEnabled() {
        return this.plugin.isEnabled();
    }

    public String getName() {
        return "EzEconomy";
    }

    public boolean hasBankSupport() {
        return this.getStorageProvider() != null;
    }

    public int fractionalDigits() {
        return 2;
    }

    public String format(double amount) {
        return this.plugin.format(amount);
    }

    public String currencyNamePlural() {
        return "Dollars";
    }

    public String currencyNameSingular() {
        return "Dollar";
    }

    public boolean hasAccount(String playerName) {
        return true;
    }

    public double getBalance(String playerName) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(playerName);
        return this.getBalance(player);
    }

    public double getBalance(OfflinePlayer player) {
        StorageProvider storage = this.getStorageProvider();
        if (storage == null) {
            return 0.0;
        }
        return storage.getBalance(player.getUniqueId(), this.plugin.getDefaultCurrency());
    }

    public boolean has(String playerName, double amount) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(playerName);
        return this.has(player, amount);
    }

    public boolean has(OfflinePlayer player, double amount) {
        StorageProvider storage = this.getStorageProvider();
        if (storage == null) {
            return false;
        }
        return storage.getBalance(player.getUniqueId(), this.plugin.getDefaultCurrency()) >= amount;
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(playerName);
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        StorageProvider storage = this.getStorageProvider();
        if (storage == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Storage not available");
        }
        String currency = this.plugin.getDefaultCurrency();
        boolean success = storage.tryWithdraw(player.getUniqueId(), currency, amount);
        if (!success) {
            double balance = storage.getBalance(player.getUniqueId(), currency);
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        }
        double newBalance = storage.getBalance(player.getUniqueId(), currency);
        return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(playerName);
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        StorageProvider storage = this.getStorageProvider();
        if (storage == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Storage not available");
        }
        String currency = this.plugin.getDefaultCurrency();
        storage.deposit(player.getUniqueId(), currency, amount);
        double newBalance = storage.getBalance(player.getUniqueId(), currency);
        return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse createBank(String name, String player) {
        OfflinePlayer owner = this.plugin.getServer().getOfflinePlayer(player);
        return this.createBank(name, owner);
    }

    public EconomyResponse createBank(String name, OfflinePlayer player) {
        StorageProvider storage = this.getStorageProvider();
        if (storage == null) {
            return this.notSupported();
        }
        if (storage.bankExists(name)) {
            return new EconomyResponse(0.0, storage.getBankBalance(name), EconomyResponse.ResponseType.FAILURE, "Bank already exists");
        }
        boolean created = storage.createBank(name, player.getUniqueId());
        if (!created) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Unable to create bank");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse deleteBank(String name) {
        StorageProvider storage = this.getStorageProvider();
        if (storage == null) {
            return this.notSupported();
        }
        if (!storage.bankExists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank does not exist");
        }
        boolean deleted = storage.deleteBank(name);
        if (!deleted) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Unable to delete bank");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse bankBalance(String name) {
        StorageProvider storage = this.getStorageProvider();
        if (storage == null) {
            return this.notSupported();
        }
        if (!storage.bankExists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank does not exist");
        }
        String currency = this.plugin.getDefaultCurrency();
        double balance = storage.getBankBalance(name, currency);
        return new EconomyResponse(balance, balance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse bankHas(String name, double amount) {
        StorageProvider storage = this.getStorageProvider();
        if (storage == null) {
            return this.notSupported();
        }
        if (!storage.bankExists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank does not exist");
        }
        String currency = this.plugin.getDefaultCurrency();
        double balance = storage.getBankBalance(name, currency);
        if (balance < amount) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        }
        return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        StorageProvider storage = this.getStorageProvider();
        if (storage == null) {
            return this.notSupported();
        }
        if (!storage.bankExists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank does not exist");
        }
        String currency = this.plugin.getDefaultCurrency();
        boolean success = storage.tryWithdrawBank(name, currency, amount);
        if (!success) {
            double balance = storage.getBankBalance(name, currency);
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        }
        double newBalance = storage.getBankBalance(name, currency);
        return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        StorageProvider storage = this.getStorageProvider();
        if (storage == null) {
            return this.notSupported();
        }
        if (!storage.bankExists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank does not exist");
        }
        String currency = this.plugin.getDefaultCurrency();
        storage.depositBank(name, currency, amount);
        double newBalance = storage.getBankBalance(name, currency);
        return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse isBankOwner(String name, String player) {
        OfflinePlayer owner = this.plugin.getServer().getOfflinePlayer(player);
        return this.isBankOwner(name, owner);
    }

    public EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        StorageProvider storage = this.getStorageProvider();
        if (storage == null) {
            return this.notSupported();
        }
        if (!storage.bankExists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank does not exist");
        }
        if (!storage.isBankOwner(name, player.getUniqueId())) {
            return new EconomyResponse(0.0, storage.getBankBalance(name, this.plugin.getDefaultCurrency()), EconomyResponse.ResponseType.FAILURE, "Not a bank owner");
        }
        return new EconomyResponse(0.0, storage.getBankBalance(name, this.plugin.getDefaultCurrency()), EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse isBankMember(String name, String player) {
        OfflinePlayer member = this.plugin.getServer().getOfflinePlayer(player);
        return this.isBankMember(name, member);
    }

    public EconomyResponse isBankMember(String name, OfflinePlayer player) {
        StorageProvider storage = this.getStorageProvider();
        if (storage == null) {
            return this.notSupported();
        }
        if (!storage.bankExists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank does not exist");
        }
        if (!storage.isBankMember(name, player.getUniqueId())) {
            return new EconomyResponse(0.0, storage.getBankBalance(name, this.plugin.getDefaultCurrency()), EconomyResponse.ResponseType.FAILURE, "Not a bank member");
        }
        return new EconomyResponse(0.0, storage.getBankBalance(name, this.plugin.getDefaultCurrency()), EconomyResponse.ResponseType.SUCCESS, null);
    }

    public List<String> getBanks() {
        StorageProvider storage = this.getStorageProvider();
        if (storage == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(storage.getBanks());
    }

    private EconomyResponse notSupported() {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Bank support not implemented");
    }

    private StorageProvider getStorageProvider() {
        Object storage = this.getStorage();
        if (storage instanceof StorageProvider) {
            StorageProvider provider = (StorageProvider)storage;
            return provider;
        }
        return null;
    }

    public boolean createPlayerAccount(String playerName) {
        return true;
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        return true;
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return true;
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        return true;
    }

    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.has(player, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }
}

