/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.core;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.command.BalanceCommand;
import com.skyblockexp.ezeconomy.command.BaltopCommand;
import com.skyblockexp.ezeconomy.command.BankCommand;
import com.skyblockexp.ezeconomy.command.CurrencyCommand;
import com.skyblockexp.ezeconomy.command.EcoCommand;
import com.skyblockexp.ezeconomy.command.EzEconomyCommand;
import com.skyblockexp.ezeconomy.command.PayCommand;
import com.skyblockexp.ezeconomy.core.EzEconomyMetrics;
import com.skyblockexp.ezeconomy.core.MessageProvider;
import com.skyblockexp.ezeconomy.core.VaultEconomyImpl;
import com.skyblockexp.ezeconomy.listener.DailyRewardListener;
import com.skyblockexp.ezeconomy.manager.BankInterestManager;
import com.skyblockexp.ezeconomy.manager.CurrencyManager;
import com.skyblockexp.ezeconomy.manager.CurrencyPreferenceManager;
import com.skyblockexp.ezeconomy.manager.DailyRewardManager;
import com.skyblockexp.ezeconomy.placeholder.EzEconomyPlaceholderExpansion;
import com.skyblockexp.ezeconomy.storage.MongoDBStorageProvider;
import com.skyblockexp.ezeconomy.storage.MySQLStorageProvider;
import com.skyblockexp.ezeconomy.storage.SQLiteStorageProvider;
import com.skyblockexp.ezeconomy.storage.YMLStorageProvider;
import com.skyblockexp.ezeconomy.tabcomplete.BankTabCompleter;
import com.skyblockexp.ezeconomy.tabcomplete.CurrencyTabCompleter;
import com.skyblockexp.ezeconomy.tabcomplete.EcoTabCompleter;
import com.skyblockexp.ezeconomy.tabcomplete.PayTabCompleter;
import com.skyblockexp.ezeconomy.update.SpigotUpdateChecker;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class EzEconomyPlugin
extends JavaPlugin {
    private static final int SPIGOT_RESOURCE_ID = 130975;
    private StorageProvider storage;
    private boolean storageInitFailed = false;
    private boolean storageWarningLogged = false;
    private CurrencyPreferenceManager currencyPreferenceManager;
    private CurrencyManager currencyManager;
    private final ConcurrentHashMap<UUID, Double> balances = new ConcurrentHashMap();
    private EzEconomyMetrics metrics;
    private BankInterestManager bankInterestManager;
    private DailyRewardManager dailyRewardManager;
    private MessageProvider messageProvider;
    private VaultEconomyImpl vaultEconomy;
    private FileConfiguration messagesConfig;

    public void createPlayerData(UUID uuid) {
        this.balances.putIfAbsent(uuid, 0.0);
    }

    public void deletePlayerData(UUID uuid) {
        this.balances.remove(uuid);
    }

    public double getBalance(UUID uuid) {
        return this.balances.getOrDefault(uuid, 0.0);
    }

    public void setBalance(UUID uuid, double amount) {
        this.balances.put(uuid, amount);
    }

    public void deposit(UUID uuid, double amount) {
        this.balances.put(uuid, this.getBalance(uuid) + amount);
    }

    public void withdraw(UUID uuid, double amount) {
        this.balances.put(uuid, this.getBalance(uuid) - amount);
    }

    public boolean hasEnough(UUID uuid, double amount) {
        return this.getBalance(uuid) >= amount;
    }

    public String format(double amount) {
        return String.format("$%.2f", amount);
    }

    public VaultEconomyImpl getEconomy() {
        return this.vaultEconomy;
    }

    public void onEnable() {
        String[] configFiles;
        this.saveDefaultConfig();
        for (String fileName : configFiles = new String[]{"config-yml.yml", "config-mysql.yml", "config-sqlite.yml", "config-mongodb.yml", "messages.yml"}) {
            File outFile = new File(this.getDataFolder(), fileName);
            if (outFile.exists()) continue;
            try (InputStream in = this.getResource(fileName);){
                if (in == null) continue;
                Files.copy(in, outFile.toPath(), new CopyOption[0]);
                this.getLogger().info("Created default config: " + fileName);
            }
            catch (Exception e) {
                this.getLogger().warning("Could not create default config " + fileName + ": " + e.getMessage());
            }
        }
        String storageType = this.getConfig().getString("storage", "yml").toLowerCase();
        try {
            switch (storageType) {
                case "yml": 
                case "yaml": {
                    File ymlConfigFile = new File(this.getDataFolder(), "config-yml.yml");
                    YamlConfiguration ymlConfig = YamlConfiguration.loadConfiguration((File)ymlConfigFile);
                    this.storage = new YMLStorageProvider(this, ymlConfig);
                    this.getLogger().info("Using YML storage provider.");
                    break;
                }
                case "mysql": {
                    File mysqlConfigFile = new File(this.getDataFolder(), "config-mysql.yml");
                    YamlConfiguration mysqlConfig = YamlConfiguration.loadConfiguration((File)mysqlConfigFile);
                    this.storage = new MySQLStorageProvider(this, mysqlConfig);
                    this.getLogger().info("Using MySQL storage provider.");
                    break;
                }
                case "sqlite": {
                    File sqliteConfigFile = new File(this.getDataFolder(), "config-sqlite.yml");
                    YamlConfiguration sqliteConfig = YamlConfiguration.loadConfiguration((File)sqliteConfigFile);
                    this.storage = new SQLiteStorageProvider(this, sqliteConfig);
                    this.getLogger().info("Using SQLite storage provider.");
                    break;
                }
                case "mongodb": {
                    File mongoConfigFile = new File(this.getDataFolder(), "config-mongodb.yml");
                    YamlConfiguration mongoConfig = YamlConfiguration.loadConfiguration((File)mongoConfigFile);
                    this.storage = new MongoDBStorageProvider(this, mongoConfig);
                    this.getLogger().info("Using MongoDB storage provider.");
                    break;
                }
                default: {
                    this.getLogger().warning("Unknown storage type '" + storageType + "', defaulting to YML.");
                    File ymlConfigFile2 = new File(this.getDataFolder(), "config-yml.yml");
                    YamlConfiguration ymlConfig2 = YamlConfiguration.loadConfiguration((File)ymlConfigFile2);
                    this.storage = new YMLStorageProvider(this, ymlConfig2);
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().severe("Failed to initialize storage provider: " + ex.getMessage());
            this.storage = null;
        }
        this.currencyPreferenceManager = new CurrencyPreferenceManager(this);
        this.currencyManager = new CurrencyManager(this);
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.bankInterestManager = new BankInterestManager(this);
        long interestInterval = this.getConfig().getLong("bank-interest-interval-ticks", 72000L);
        this.bankInterestManager.start(interestInterval);
        this.metrics = new EzEconomyMetrics((Plugin)this);
        this.messageProvider = new MessageProvider(this.messagesConfig);
        this.vaultEconomy = new VaultEconomyImpl(this);
        Bukkit.getServicesManager().register(Economy.class, (Object)this.vaultEconomy, (Plugin)this, ServicePriority.Highest);
        this.getLogger().info("EzEconomy enabled and registered as Vault provider.");
        new SpigotUpdateChecker(this, 130975).checkForUpdates();
        this.getCommand("balance").setExecutor((CommandExecutor)new BalanceCommand(this));
        this.getCommand("eco").setExecutor((CommandExecutor)new EcoCommand(this));
        this.getCommand("eco").setTabCompleter((TabCompleter)new EcoTabCompleter());
        this.getCommand("baltop").setExecutor((CommandExecutor)new BaltopCommand(this));
        this.getCommand("bank").setExecutor((CommandExecutor)new BankCommand(this));
        this.getCommand("bank").setTabCompleter((TabCompleter)new BankTabCompleter());
        this.getCommand("pay").setExecutor((CommandExecutor)new PayCommand(this));
        this.getCommand("pay").setTabCompleter((TabCompleter)new PayTabCompleter());
        this.getCommand("currency").setExecutor((CommandExecutor)new CurrencyCommand(this));
        this.getCommand("currency").setTabCompleter((TabCompleter)new CurrencyTabCompleter());
        this.dailyRewardManager = new DailyRewardManager(this);
        this.getCommand("ezeconomy").setExecutor((CommandExecutor)new EzEconomyCommand(this, this.dailyRewardManager));
        Bukkit.getPluginManager().registerEvents((Listener)new DailyRewardListener(this.dailyRewardManager), (Plugin)this);
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new EzEconomyPlaceholderExpansion(this).register();
            this.getLogger().info("Registered EzEconomy placeholders with PlaceholderAPI.");
        }
    }

    public EzEconomyMetrics getMetrics() {
        return this.metrics;
    }

    public void onDisable() {
        Bukkit.getServicesManager().unregister(Economy.class, (Object)this.vaultEconomy);
        this.getLogger().info("EzEconomy disabled.");
    }

    public MessageProvider getMessageProvider() {
        return this.messageProvider;
    }

    public VaultEconomyImpl getVaultEconomy() {
        return this.vaultEconomy;
    }

    public BankInterestManager getBankInterestManager() {
        return this.bankInterestManager;
    }

    public String getDefaultCurrency() {
        return this.currencyManager.getDefaultCurrency();
    }

    public StorageProvider getStorageOrWarn() {
        if (this.storage == null && !this.storageWarningLogged) {
            this.getLogger().warning("Storage provider is not initialized!");
            this.storageWarningLogged = true;
        }
        return this.storage;
    }

    public StorageProvider getStorage() {
        return this.storage;
    }

    public CurrencyPreferenceManager getCurrencyPreferenceManager() {
        return this.currencyPreferenceManager;
    }
}

