/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.api.storage;

import com.skyblockexp.ezeconomy.storage.TransferLockManager;
import com.skyblockexp.ezeconomy.storage.TransferResult;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;

public interface StorageProvider {
    public double getBalance(UUID var1, String var2);

    public void setBalance(UUID var1, String var2, double var3);

    public boolean tryWithdraw(UUID var1, String var2, double var3);

    public void deposit(UUID var1, String var2, double var3);

    public Map<UUID, Double> getAllBalances(String var1);

    default public TransferResult transfer(UUID fromUuid, UUID toUuid, String currency, double amount) {
        return this.transfer(fromUuid, toUuid, currency, amount, amount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public TransferResult transfer(UUID fromUuid, UUID toUuid, String currency, double debitAmount, double creditAmount) {
        if (debitAmount < 0.0 || creditAmount < 0.0) {
            return TransferResult.failure(this.getBalance(fromUuid, currency), this.getBalance(toUuid, currency));
        }
        ReentrantLock lock = TransferLockManager.getLock(fromUuid);
        lock.lock();
        try {
            double fromBalance = this.getBalance(fromUuid, currency);
            if (fromBalance < debitAmount) {
                double toBalance = this.getBalance(toUuid, currency);
                TransferResult transferResult = TransferResult.failure(fromBalance, toBalance);
                return transferResult;
            }
            if (!this.tryWithdraw(fromUuid, currency, debitAmount)) {
                double refreshedFrom = this.getBalance(fromUuid, currency);
                double toBalance = this.getBalance(toUuid, currency);
                TransferResult transferResult = TransferResult.failure(refreshedFrom, toBalance);
                return transferResult;
            }
            if (creditAmount > 0.0) {
                this.deposit(toUuid, currency, creditAmount);
            }
            double updatedFrom = this.getBalance(fromUuid, currency);
            double updatedTo = this.getBalance(toUuid, currency);
            TransferResult transferResult = TransferResult.success(updatedFrom, updatedTo);
            return transferResult;
        }
        finally {
            lock.unlock();
        }
    }

    @Deprecated
    default public double getBalance(UUID uuid) {
        return this.getBalance(uuid, "dollar");
    }

    @Deprecated
    default public void setBalance(UUID uuid, double amount) {
        this.setBalance(uuid, "dollar", amount);
    }

    @Deprecated
    default public boolean tryWithdraw(UUID uuid, double amount) {
        return this.tryWithdraw(uuid, "dollar", amount);
    }

    @Deprecated
    default public void deposit(UUID uuid, double amount) {
        this.deposit(uuid, "dollar", amount);
    }

    @Deprecated
    default public Map<UUID, Double> getAllBalances() {
        return this.getAllBalances("dollar");
    }

    public void shutdown();

    public boolean createBank(String var1, UUID var2);

    public boolean deleteBank(String var1);

    public boolean bankExists(String var1);

    public double getBankBalance(String var1, String var2);

    public void setBankBalance(String var1, String var2, double var3);

    public boolean tryWithdrawBank(String var1, String var2, double var3);

    public void depositBank(String var1, String var2, double var3);

    public Set<String> getBanks();

    public boolean isBankOwner(String var1, UUID var2);

    public boolean isBankMember(String var1, UUID var2);

    public boolean addBankMember(String var1, UUID var2);

    public boolean removeBankMember(String var1, UUID var2);

    public Set<UUID> getBankMembers(String var1);

    @Deprecated
    default public double getBankBalance(String name) {
        return this.getBankBalance(name, "dollar");
    }

    @Deprecated
    default public void setBankBalance(String name, double amount) {
        this.setBankBalance(name, "dollar", amount);
    }

    @Deprecated
    default public boolean tryWithdrawBank(String name, double amount) {
        return this.tryWithdrawBank(name, "dollar", amount);
    }

    @Deprecated
    default public void depositBank(String name, double amount) {
        this.depositBank(name, "dollar", amount);
    }
}

