/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezcountdown.manager;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class MessageManager {
    private final JavaPlugin plugin;
    private FileConfiguration configuration;
    private String prefix;
    private boolean miniMessageEnabled;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build();

    public MessageManager(JavaPlugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.reload();
    }

    public void reload() {
        File file = new File(this.plugin.getDataFolder(), "messages.yml");
        this.configuration = YamlConfiguration.loadConfiguration((File)file);
        this.prefix = this.configuration.getString("prefix", "");
        this.miniMessageEnabled = this.configuration.getBoolean("use-minimessage", false);
    }

    public String raw(String key) {
        return this.configuration.getString(key, "");
    }

    public String message(String key) {
        return this.formatWithPrefix(this.raw(key), Map.of());
    }

    public String message(String key, Map<String, String> placeholders) {
        return this.formatWithPrefix(this.raw(key), placeholders);
    }

    public String format(String input) {
        return this.serialize(input);
    }

    public String formatWithPrefix(String input, Map<String, String> placeholders) {
        String message = this.applyPlaceholders(input, placeholders);
        message = message.replace("{prefix}", this.prefix == null ? "" : this.prefix);
        return this.serialize(message);
    }

    private String applyPlaceholders(String input, Map<String, String> placeholders) {
        String result = input == null ? "" : input;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            result = result.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return result;
    }

    private String serialize(String input) {
        if (input == null) {
            return "";
        }
        if (!this.miniMessageEnabled) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
        }
        Object component = this.miniMessage.deserialize(input);
        String legacy = this.legacySerializer.serialize((Component)component);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)legacy);
    }
}

