/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezcountdown.location;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.yaml.snakeyaml.Yaml;

public class LocationManager {
    private final File file;
    private final Map<String, Location> locations = new HashMap<String, Location>();

    public LocationManager(File dataFolder) {
        this.file = new File(dataFolder, "locations.yml");
        this.loadLocations();
    }

    public void loadLocations() {
        this.locations.clear();
        if (!this.file.exists()) {
            return;
        }
        Yaml yaml = new Yaml();
        try (FileReader reader = new FileReader(this.file);){
            Map data = (Map)yaml.load((Reader)reader);
            if (data == null) {
                return;
            }
            for (String name : data.keySet()) {
                Map locData = (Map)data.get(name);
                World world = Bukkit.getWorld((String)((String)locData.get("world")));
                if (world == null) continue;
                double x = Double.parseDouble(locData.get("x").toString());
                double y = Double.parseDouble(locData.get("y").toString());
                double z = Double.parseDouble(locData.get("z").toString());
                float yaw = Float.parseFloat(locData.get("yaw").toString());
                float pitch = Float.parseFloat(locData.get("pitch").toString());
                this.locations.put(name, new Location(world, x, y, z, yaw, pitch));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveLocations() {
        Yaml yaml = new Yaml();
        HashMap data = new HashMap();
        for (Map.Entry<String, Location> entry : this.locations.entrySet()) {
            Location loc = entry.getValue();
            HashMap<String, Object> locData = new HashMap<String, Object>();
            locData.put("world", loc.getWorld().getName());
            locData.put("x", loc.getX());
            locData.put("y", loc.getY());
            locData.put("z", loc.getZ());
            locData.put("yaw", Float.valueOf(loc.getYaw()));
            locData.put("pitch", Float.valueOf(loc.getPitch()));
            data.put(entry.getKey(), locData);
        }
        try (FileWriter writer = new FileWriter(this.file);){
            yaml.dump(data, (Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean addLocation(String name, Location location) {
        if (this.locations.containsKey(name)) {
            return false;
        }
        this.locations.put(name, location);
        this.saveLocations();
        return true;
    }

    public boolean deleteLocation(String name) {
        if (!this.locations.containsKey(name)) {
            return false;
        }
        this.locations.remove(name);
        this.saveLocations();
        return true;
    }

    public Location getLocation(String name) {
        return this.locations.get(name);
    }

    public void teleportPlayer(Player player, String locationName) {
        Location loc = this.getLocation(locationName);
        if (loc != null) {
            player.teleport(loc);
        }
    }

    public List<String> getLocationNames() {
        return new ArrayList<String>(this.locations.keySet());
    }
}

