/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezcountdown.firework;

import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class FireworkShowManager {
    public void launchCircleFireworkShow(World world, Location center, String colorName, int power, int count, int rows, int intervalTicks) {
        if (world == null || center == null || colorName == null || count <= 0 || rows <= 0) {
            return;
        }
        Color color = this.parseColor(colorName);
        double baseRadius = 6.0;
        for (int row = 0; row < rows; ++row) {
            int currentRow = row;
            Bukkit.getScheduler().runTaskLater(Bukkit.getPluginManager().getPlugins()[0], () -> {
                double radius = 6.0 + (double)currentRow * 2.5;
                for (int i = 0; i < count; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)count;
                    double x = center.getX() + radius * Math.cos(angle);
                    double z = center.getZ() + radius * Math.sin(angle);
                    Location loc = new Location(world, x, center.getY() + 1.0, z);
                    this.spawnFirework(loc, color != null ? color : Color.WHITE, power);
                }
            }, (long)(row * intervalTicks));
        }
    }

    private void spawnFirework(Location loc, Color color, int power) {
        Firework firework = (Firework)loc.getWorld().spawn(loc, Firework.class);
        FireworkMeta meta = firework.getFireworkMeta();
        meta.addEffect(FireworkEffect.builder().with(FireworkEffect.Type.BALL).withColor(color).withFade(color).flicker(true).trail(true).build());
        meta.setPower(power);
        firework.setFireworkMeta(meta);
    }

    private Color parseColor(String name) {
        try {
            return (Color)Color.class.getField(name.toUpperCase(Locale.ROOT)).get(null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

