/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezcountdown.display;

import com.skyblockexp.ezcountdown.countdown.Countdown;
import com.skyblockexp.ezcountdown.display.DisplayType;
import com.skyblockexp.ezcountdown.util.BossBarSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public final class DisplayManager {
    private final JavaPlugin plugin;
    private final Map<String, BossBar> bossBars = new HashMap<String, BossBar>();

    public DisplayManager(JavaPlugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
    }

    public void display(Countdown countdown, String message, long remainingSeconds) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.canSee(player, countdown)) continue;
            if (countdown.getDisplayTypes().contains((Object)DisplayType.ACTION_BAR)) {
                this.sendActionBar(player, message);
            }
            if (countdown.getDisplayTypes().contains((Object)DisplayType.CHAT)) {
                player.sendMessage(message);
            }
            if (countdown.getDisplayTypes().contains((Object)DisplayType.TITLE)) {
                player.sendTitle(message, "", 10, 40, 10);
            }
            if (!countdown.getDisplayTypes().contains((Object)DisplayType.SCOREBOARD)) continue;
            this.updateScoreboard(player, countdown, message);
        }
        if (countdown.getDisplayTypes().contains((Object)DisplayType.BOSS_BAR)) {
            this.updateBossBar(countdown, message, remainingSeconds);
        }
    }

    public void broadcastMessage(String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(message);
        }
    }

    public void clearCountdown(Countdown countdown) {
        BossBar bossBar = this.bossBars.remove(countdown.getName());
        if (bossBar != null) {
            bossBar.removeAll();
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!countdown.getDisplayTypes().contains((Object)DisplayType.SCOREBOARD)) continue;
            this.clearScoreboard(player, countdown);
        }
    }

    public void clearAll() {
        for (BossBar bossBar : this.bossBars.values()) {
            bossBar.removeAll();
        }
        this.bossBars.clear();
    }

    private boolean canSee(Player player, Countdown countdown) {
        String permission = countdown.getVisibilityPermission();
        return permission == null || permission.isBlank() || player.hasPermission(permission);
    }

    private void updateBossBar(Countdown countdown, String message, long remainingSeconds) {
        if (!BossBarSupport.isSupported()) {
            return;
        }
        BossBar bossBar = this.bossBars.computeIfAbsent(countdown.getName(), name -> Bukkit.createBossBar((String)message, (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]));
        bossBar.setTitle(message);
        bossBar.setProgress(this.calculateProgress(countdown, remainingSeconds));
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.canSee(player, countdown)) {
                bossBar.addPlayer(player);
                continue;
            }
            bossBar.removePlayer(player);
        }
    }

    private double calculateProgress(Countdown countdown, long remainingSeconds) {
        long duration = countdown.getDurationSeconds();
        if (duration <= 0L) {
            return 1.0;
        }
        double progress = (double)remainingSeconds / (double)duration;
        if (progress < 0.0) {
            return 0.0;
        }
        return Math.min(1.0, progress);
    }

    private void updateScoreboard(Player player, Countdown countdown, String message) {
        String objectiveName;
        Objective objective;
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        if (manager == null) {
            return;
        }
        Scoreboard scoreboard = player.getScoreboard();
        if (scoreboard == manager.getMainScoreboard()) {
            scoreboard = manager.getNewScoreboard();
            player.setScoreboard(scoreboard);
        }
        if ((objective = scoreboard.getObjective(objectiveName = this.buildObjectiveName(countdown.getName()))) == null) {
            objective = scoreboard.registerNewObjective(objectiveName, "dummy", String.valueOf(ChatColor.AQUA) + "Countdown");
        }
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        scoreboard.getEntries().forEach(arg_0 -> ((Scoreboard)scoreboard).resetScores(arg_0));
        objective.getScore(message).setScore(1);
    }

    private void clearScoreboard(Player player, Countdown countdown) {
        Scoreboard scoreboard = player.getScoreboard();
        if (scoreboard == null) {
            return;
        }
        String objectiveName = this.buildObjectiveName(countdown.getName());
        Objective objective = scoreboard.getObjective(objectiveName);
        if (objective != null) {
            objective.unregister();
        }
    }

    private String buildObjectiveName(String name) {
        String normalized = name.toLowerCase();
        String base = "ezcd_" + normalized.replaceAll("[^a-z0-9]", "");
        return base.length() > 16 ? base.substring(0, 16) : base;
    }

    private void sendActionBar(Player player, String message) {
        try {
            player.sendActionBar(message);
        }
        catch (NoSuchMethodError err) {
            try {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
            }
            catch (NoClassDefFoundError ignored) {
                player.sendMessage(message);
            }
        }
    }
}

