/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezcountdown.countdown;

import com.skyblockexp.ezcountdown.countdown.CountdownType;
import com.skyblockexp.ezcountdown.display.DisplayType;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;

public final class Countdown {
    private final String name;
    private final CountdownType type;
    private final EnumSet<DisplayType> displayTypes;
    private final int updateIntervalSeconds;
    private final String visibilityPermission;
    private final String formatMessage;
    private final String startMessage;
    private final String endMessage;
    private final List<String> endCommands;
    private final ZoneId zoneId;
    private long durationSeconds;
    private Instant targetInstant;
    private int recurringMonth;
    private int recurringDay;
    private LocalTime recurringTime;
    private boolean running;

    public Countdown(String name, CountdownType type, EnumSet<DisplayType> displayTypes, int updateIntervalSeconds, String visibilityPermission, String formatMessage, String startMessage, String endMessage, List<String> endCommands, ZoneId zoneId) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
        this.displayTypes = displayTypes == null ? EnumSet.noneOf(DisplayType.class) : EnumSet.copyOf(displayTypes);
        this.updateIntervalSeconds = updateIntervalSeconds;
        this.visibilityPermission = visibilityPermission;
        this.formatMessage = formatMessage;
        this.startMessage = startMessage;
        this.endMessage = endMessage;
        this.endCommands = endCommands == null ? List.of() : List.copyOf(endCommands);
        this.zoneId = zoneId;
    }

    public String getName() {
        return this.name;
    }

    public CountdownType getType() {
        return this.type;
    }

    public EnumSet<DisplayType> getDisplayTypes() {
        return EnumSet.copyOf(this.displayTypes);
    }

    public int getUpdateIntervalSeconds() {
        return this.updateIntervalSeconds;
    }

    public String getVisibilityPermission() {
        return this.visibilityPermission;
    }

    public String getFormatMessage() {
        return this.formatMessage;
    }

    public String getStartMessage() {
        return this.startMessage;
    }

    public String getEndMessage() {
        return this.endMessage;
    }

    public List<String> getEndCommands() {
        return List.copyOf(this.endCommands);
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public long getDurationSeconds() {
        return this.durationSeconds;
    }

    public void setDurationSeconds(long durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public Instant getTargetInstant() {
        return this.targetInstant;
    }

    public void setTargetInstant(Instant targetInstant) {
        this.targetInstant = targetInstant;
    }

    public int getRecurringMonth() {
        return this.recurringMonth;
    }

    public void setRecurringMonth(int recurringMonth) {
        this.recurringMonth = recurringMonth;
    }

    public int getRecurringDay() {
        return this.recurringDay;
    }

    public void setRecurringDay(int recurringDay) {
        this.recurringDay = recurringDay;
    }

    public LocalTime getRecurringTime() {
        return this.recurringTime;
    }

    public void setRecurringTime(LocalTime recurringTime) {
        this.recurringTime = recurringTime;
    }

    public Instant resolveNextRecurringTarget(Instant now) {
        LocalDate currentDate = LocalDate.ofInstant(now, this.zoneId);
        LocalDate targetDate = LocalDate.of(currentDate.getYear(), this.recurringMonth, this.recurringDay);
        if (!(targetDate.isAfter(currentDate) && !targetDate.isEqual(currentDate) || LocalTime.ofInstant(now, this.zoneId).isBefore(this.recurringTime))) {
            targetDate = targetDate.plusYears(1L);
        }
        return targetDate.atTime(this.recurringTime).atZone(this.zoneId).toInstant();
    }
}

