/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezcountdown.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DurationParser {
    private static final Pattern TOKEN_PATTERN = Pattern.compile("(\\d+)([smhd])", 2);

    private DurationParser() {
    }

    public static long parseToSeconds(String input) {
        if (input == null || input.isBlank()) {
            throw new IllegalArgumentException("Duration input is empty.");
        }
        Matcher matcher = TOKEN_PATTERN.matcher(input.replace(" ", ""));
        long totalSeconds = 0L;
        int matches = 0;
        block12: while (matcher.find()) {
            String unit;
            ++matches;
            long value = Long.parseLong(matcher.group(1));
            switch (unit = matcher.group(2).toLowerCase()) {
                case "s": {
                    totalSeconds += value;
                    continue block12;
                }
                case "m": {
                    totalSeconds += value * 60L;
                    continue block12;
                }
                case "h": {
                    totalSeconds += value * 3600L;
                    continue block12;
                }
                case "d": {
                    totalSeconds += value * 86400L;
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Unsupported duration unit: " + unit);
        }
        if (matches == 0) {
            throw new IllegalArgumentException("Invalid duration format. Use values like 10m, 2h, or 1d4h.");
        }
        return totalSeconds;
    }
}

