/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezcountdown.command;

import com.skyblockexp.ezcountdown.command.CountdownPermissions;
import com.skyblockexp.ezcountdown.countdown.Countdown;
import com.skyblockexp.ezcountdown.countdown.CountdownType;
import com.skyblockexp.ezcountdown.display.DisplayType;
import com.skyblockexp.ezcountdown.manager.CountdownDefaults;
import com.skyblockexp.ezcountdown.manager.CountdownManager;
import com.skyblockexp.ezcountdown.manager.MessageManager;
import com.skyblockexp.ezcountdown.util.DurationParser;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public final class CountdownCommand
implements CommandExecutor,
TabCompleter {
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private final CountdownManager manager;
    private final CountdownDefaults defaults;
    private final CountdownPermissions permissions;
    private final MessageManager messageManager;
    private final Runnable reloadAction;

    public CountdownCommand(CountdownManager manager, CountdownDefaults defaults, CountdownPermissions permissions, MessageManager messageManager, Runnable reloadAction) {
        this.manager = manager;
        this.defaults = defaults;
        this.permissions = permissions;
        this.messageManager = messageManager;
        this.reloadAction = reloadAction;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (!this.hasPermission(sender, this.permissions.base())) {
            sender.sendMessage(this.messageManager.message("commands.no-permission"));
            return true;
        }
        if (args.length == 0) {
            this.sendUsage(sender);
            return true;
        }
        switch (sub = args[0].toLowerCase(Locale.ROOT)) {
            case "create": {
                this.handleCreate(sender, args);
                break;
            }
            case "start": {
                this.handleStart(sender, args);
                break;
            }
            case "stop": {
                this.handleStop(sender, args);
                break;
            }
            case "delete": {
                this.handleDelete(sender, args);
                break;
            }
            case "list": {
                this.handleList(sender);
                break;
            }
            case "info": {
                this.handleInfo(sender, args);
                break;
            }
            case "reload": {
                this.handleReload(sender, command);
                break;
            }
            default: {
                this.sendUsage(sender);
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return List.of("create", "start", "stop", "delete", "list", "info", "reload").stream().filter(entry -> entry.startsWith(args[0].toLowerCase(Locale.ROOT))).toList();
        }
        if (args.length == 2 && ("start".equalsIgnoreCase(args[0]) || "stop".equalsIgnoreCase(args[0]) || "delete".equalsIgnoreCase(args[0]) || "info".equalsIgnoreCase(args[0]))) {
            return this.manager.getCountdowns().stream().map(Countdown::getName).filter(name -> name.toLowerCase(Locale.ROOT).startsWith(args[1].toLowerCase(Locale.ROOT))).sorted().toList();
        }
        if (args.length == 3 && "create".equalsIgnoreCase(args[0])) {
            return List.of("manual", "recurring", "duration", "2026-01-01");
        }
        return List.of();
    }

    private void handleCreate(CommandSender sender, String[] args) {
        Countdown countdown;
        if (!this.hasPermission(sender, this.permissions.create())) {
            sender.sendMessage(this.messageManager.message("commands.create.no-permission"));
            return;
        }
        if (args.length < 3) {
            sender.sendMessage(this.messageManager.message("commands.create.usage"));
            return;
        }
        String name = args[1];
        String typeToken = args[2];
        if ("recurring".equalsIgnoreCase(typeToken)) {
            LocalTime time;
            int day;
            int month;
            if (args.length < 6) {
                sender.sendMessage(this.messageManager.message("commands.create.recurring-usage"));
                return;
            }
            try {
                month = Integer.parseInt(args[3]);
                day = Integer.parseInt(args[4]);
                time = LocalTime.parse(args[5]);
            }
            catch (NumberFormatException | DateTimeParseException ex) {
                sender.sendMessage(this.messageManager.message("commands.create.invalid-recurring"));
                return;
            }
            countdown = this.buildCountdown(name, CountdownType.RECURRING);
            countdown.setRecurringMonth(month);
            countdown.setRecurringDay(day);
            countdown.setRecurringTime(time);
            countdown.setTargetInstant(countdown.resolveNextRecurringTarget(Instant.now()));
            countdown.setRunning(true);
        } else if ("manual".equalsIgnoreCase(typeToken)) {
            if (args.length < 4) {
                sender.sendMessage(this.messageManager.message("commands.create.manual-usage"));
                return;
            }
            countdown = this.buildCountdown(name, CountdownType.MANUAL);
            try {
                countdown.setDurationSeconds(DurationParser.parseToSeconds(args[3]));
            }
            catch (IllegalArgumentException ex) {
                sender.sendMessage(this.messageManager.message("commands.create.invalid-duration", Map.of("reason", ex.getMessage())));
                return;
            }
            countdown.setRunning(false);
        } else if ("duration".equalsIgnoreCase(typeToken)) {
            if (args.length < 4) {
                sender.sendMessage(this.messageManager.message("commands.create.duration-usage"));
                return;
            }
            countdown = this.buildCountdown(name, CountdownType.DURATION);
            try {
                countdown.setDurationSeconds(DurationParser.parseToSeconds(args[3]));
            }
            catch (IllegalArgumentException ex) {
                sender.sendMessage(this.messageManager.message("commands.create.invalid-duration", Map.of("reason", ex.getMessage())));
                return;
            }
            countdown.setRunning(this.defaults.startOnCreate());
            if (countdown.isRunning()) {
                countdown.setTargetInstant(Instant.now().plusSeconds(countdown.getDurationSeconds()));
            }
        } else {
            String date = typeToken;
            String time = args.length > 3 ? args[3] : "00:00";
            try {
                LocalDateTime parsed = LocalDateTime.parse(date + " " + time, DATE_TIME_FORMAT);
                ZoneId zoneId = this.defaults.zoneId();
                countdown = this.buildCountdown(name, CountdownType.FIXED_DATE);
                countdown.setTargetInstant(parsed.atZone(zoneId).toInstant());
                countdown.setRunning(this.defaults.startOnCreate());
            }
            catch (DateTimeParseException ex) {
                sender.sendMessage(this.messageManager.message("commands.create.invalid-date"));
                return;
            }
        }
        if (!this.manager.createCountdown(countdown)) {
            sender.sendMessage(this.messageManager.message("commands.create.exists", Map.of("name", name)));
            return;
        }
        this.manager.save();
        sender.sendMessage(this.messageManager.message("commands.create.success", Map.of("name", name)));
    }

    private void handleStart(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, this.permissions.start())) {
            sender.sendMessage(this.messageManager.message("commands.start.no-permission"));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(this.messageManager.message("commands.start.usage"));
            return;
        }
        if (this.manager.startCountdown(args[1])) {
            this.manager.save();
            sender.sendMessage(this.messageManager.message("commands.start.success", Map.of("name", args[1])));
        } else {
            sender.sendMessage(this.messageManager.message("commands.start.missing", Map.of("name", args[1])));
        }
    }

    private void handleStop(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, this.permissions.stop())) {
            sender.sendMessage(this.messageManager.message("commands.stop.no-permission"));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(this.messageManager.message("commands.stop.usage"));
            return;
        }
        if (this.manager.stopCountdown(args[1])) {
            this.manager.save();
            sender.sendMessage(this.messageManager.message("commands.stop.success", Map.of("name", args[1])));
        } else {
            sender.sendMessage(this.messageManager.message("commands.stop.missing", Map.of("name", args[1])));
        }
    }

    private void handleDelete(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, this.permissions.delete())) {
            sender.sendMessage(this.messageManager.message("commands.delete.no-permission"));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(this.messageManager.message("commands.delete.usage"));
            return;
        }
        if (this.manager.deleteCountdown(args[1])) {
            this.manager.save();
            sender.sendMessage(this.messageManager.message("commands.delete.success", Map.of("name", args[1])));
        } else {
            sender.sendMessage(this.messageManager.message("commands.delete.missing", Map.of("name", args[1])));
        }
    }

    private void handleList(CommandSender sender) {
        if (!this.hasPermission(sender, this.permissions.list())) {
            sender.sendMessage(this.messageManager.message("commands.list.no-permission"));
            return;
        }
        if (this.manager.getCountdowns().isEmpty()) {
            sender.sendMessage(this.messageManager.message("commands.list.empty"));
            return;
        }
        String entryFormat = this.messageManager.raw("commands.list.entry");
        String separator = this.messageManager.raw("commands.list.separator");
        String runningLabel = this.messageManager.raw("commands.list.status.running");
        String stoppedLabel = this.messageManager.raw("commands.list.status.stopped");
        StringJoiner joiner = new StringJoiner(separator);
        for (Countdown countdown : this.manager.getCountdowns()) {
            String entry = entryFormat.replace("{name}", countdown.getName()).replace("{status}", countdown.isRunning() ? runningLabel : stoppedLabel);
            joiner.add(entry);
        }
        sender.sendMessage(this.messageManager.message("commands.list.format", Map.of("list", joiner.toString())));
    }

    private void handleInfo(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, this.permissions.info())) {
            sender.sendMessage(this.messageManager.message("commands.info.no-permission"));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(this.messageManager.message("commands.info.usage"));
            return;
        }
        Optional<Countdown> countdownOptional = this.manager.getCountdown(args[1]);
        if (countdownOptional.isEmpty()) {
            sender.sendMessage(this.messageManager.message("commands.info.missing", Map.of("name", args[1])));
            return;
        }
        Countdown countdown = countdownOptional.get();
        sender.sendMessage(this.messageManager.message("commands.info.header", Map.of("name", countdown.getName())));
        sender.sendMessage(this.messageManager.message("commands.info.type", Map.of("type", countdown.getType().name())));
        sender.sendMessage(this.messageManager.message("commands.info.running", Map.of("running", String.valueOf(countdown.isRunning()))));
        sender.sendMessage(this.messageManager.message("commands.info.display", Map.of("display", countdown.getDisplayTypes().toString())));
        if (countdown.getTargetInstant() != null) {
            sender.sendMessage(this.messageManager.message("commands.info.target", Map.of("target", countdown.getTargetInstant().atZone(countdown.getZoneId()).toString())));
        }
    }

    private void handleReload(CommandSender sender, Command command) {
        if (!this.hasPermission(sender, this.permissions.reload())) {
            sender.sendMessage(this.messageManager.message("commands.reload.no-permission"));
            return;
        }
        if (this.reloadAction != null) {
            this.reloadAction.run();
            sender.sendMessage(this.messageManager.message("commands.reload.success"));
        } else {
            sender.sendMessage(this.messageManager.message("commands.reload.unsupported"));
        }
    }

    private Countdown buildCountdown(String name, CountdownType type) {
        EnumSet<DisplayType> displayTypes = EnumSet.copyOf(this.defaults.displayTypes());
        Countdown countdown = new Countdown(name, type, displayTypes, this.defaults.updateIntervalSeconds(), this.defaults.visibilityPermission(), this.defaults.formatMessage(), this.defaults.startMessage(), this.defaults.endMessage(), List.of(), this.defaults.zoneId());
        countdown.setRunning(this.defaults.startOnCreate());
        return countdown;
    }

    private void sendUsage(CommandSender sender) {
        sender.sendMessage(this.messageManager.message("commands.usage.header"));
        sender.sendMessage(this.messageManager.message("commands.usage.create"));
        sender.sendMessage(this.messageManager.message("commands.usage.start"));
        sender.sendMessage(this.messageManager.message("commands.usage.stop"));
        sender.sendMessage(this.messageManager.message("commands.usage.delete"));
        sender.sendMessage(this.messageManager.message("commands.usage.list"));
        sender.sendMessage(this.messageManager.message("commands.usage.info"));
        sender.sendMessage(this.messageManager.message("commands.usage.reload"));
    }

    private boolean hasPermission(CommandSender sender, String permission) {
        return permission == null || permission.isBlank() || sender.hasPermission(permission);
    }
}

