/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezcountdown.placeholder;

import com.skyblockexp.ezcountdown.countdown.Countdown;
import com.skyblockexp.ezcountdown.manager.CountdownManager;
import com.skyblockexp.ezcountdown.util.TimeFormat;
import java.time.Instant;
import java.util.Locale;
import java.util.Optional;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class EzCountdownPlaceholderExpansion
extends PlaceholderExpansion {
    private final JavaPlugin plugin;
    private final CountdownManager manager;

    public EzCountdownPlaceholderExpansion(JavaPlugin plugin, CountdownManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public String getIdentifier() {
        return "ezcountdown";
    }

    public String getAuthor() {
        return String.join((CharSequence)", ", this.plugin.getDescription().getAuthors());
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (identifier == null || identifier.isBlank()) {
            return "";
        }
        int lastUnderscore = identifier.lastIndexOf(95);
        if (lastUnderscore < 0 || lastUnderscore == identifier.length() - 1) {
            return "";
        }
        String name = identifier.substring(0, lastUnderscore);
        String field = identifier.substring(lastUnderscore + 1).toLowerCase(Locale.ROOT);
        Optional<Countdown> countdownOptional = this.manager.getCountdown(name);
        if (countdownOptional.isEmpty()) {
            return "";
        }
        Countdown countdown = countdownOptional.get();
        if (!countdown.isRunning() || countdown.getTargetInstant() == null) {
            return "0";
        }
        long remaining = Math.max(0L, countdown.getTargetInstant().getEpochSecond() - Instant.now().getEpochSecond());
        TimeFormat.TimeParts parts = TimeFormat.toParts(remaining);
        return switch (field) {
            case "days" -> String.valueOf(parts.days());
            case "hours" -> String.valueOf(parts.hours());
            case "minutes" -> String.valueOf(parts.minutes());
            case "seconds" -> String.valueOf(parts.seconds());
            case "formatted" -> TimeFormat.format(parts);
            default -> "";
        };
    }
}

