/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezcountdown;

import com.skyblockexp.ezcountdown.command.CountdownCommand;
import com.skyblockexp.ezcountdown.command.CountdownPermissions;
import com.skyblockexp.ezcountdown.display.DisplayManager;
import com.skyblockexp.ezcountdown.display.DisplayType;
import com.skyblockexp.ezcountdown.libs.org.bstats.bukkit.Metrics;
import com.skyblockexp.ezcountdown.libs.org.bstats.charts.SingleLineChart;
import com.skyblockexp.ezcountdown.manager.CountdownDefaults;
import com.skyblockexp.ezcountdown.manager.CountdownManager;
import com.skyblockexp.ezcountdown.manager.MessageManager;
import com.skyblockexp.ezcountdown.placeholder.EzCountdownPlaceholderExpansion;
import com.skyblockexp.ezcountdown.storage.CountdownStorage;
import com.skyblockexp.ezcountdown.storage.YamlCountdownStorage;
import java.io.File;
import java.time.ZoneId;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class EzCountdownPlugin
extends JavaPlugin {
    private static final int BSTATS_PLUGIN_ID = 28545;
    private CountdownManager countdownManager;
    private CountdownDefaults defaults;
    private CountdownPermissions permissions;
    private MessageManager messageManager;
    private DisplayManager displayManager;
    private CountdownStorage storage;
    private EzCountdownPlaceholderExpansion placeholderExpansion;

    public void onEnable() {
        this.saveDefaultConfig();
        this.ensureResource("messages.yml");
        this.reloadComponents();
        this.initializeMetrics();
        this.getLogger().info("EzCountdown has been enabled.");
    }

    public void onDisable() {
        if (this.placeholderExpansion != null) {
            this.placeholderExpansion.unregister();
            this.placeholderExpansion = null;
        }
        if (this.countdownManager != null) {
            this.countdownManager.shutdown();
            this.countdownManager = null;
        }
        this.displayManager = null;
        this.storage = null;
        this.getLogger().info("EzCountdown has been disabled.");
    }

    public void reloadComponents() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        this.messageManager = new MessageManager(this);
        this.defaults = this.loadDefaults(config);
        this.permissions = this.loadPermissions(config);
        this.displayManager = new DisplayManager(this);
        File storageFile = new File(this.getDataFolder(), "countdowns.yml");
        this.storage = new YamlCountdownStorage(this, this.defaults, storageFile);
        if (this.countdownManager != null) {
            this.countdownManager.shutdown(false);
        }
        this.countdownManager = new CountdownManager(this, this.storage, this.displayManager, this.messageManager);
        this.countdownManager.load();
        PluginCommand command = this.getCommand("countdown");
        if (command != null) {
            CountdownCommand executor = new CountdownCommand(this.countdownManager, this.defaults, this.permissions, this.messageManager, this::reloadComponents);
            command.setExecutor((CommandExecutor)executor);
            command.setTabCompleter((TabCompleter)executor);
        }
        this.hookPlaceholderApi();
    }

    private void hookPlaceholderApi() {
        Plugin placeholder = this.getServer().getPluginManager().getPlugin("PlaceholderAPI");
        if (placeholder == null) {
            return;
        }
        if (this.placeholderExpansion != null) {
            this.placeholderExpansion.unregister();
        }
        this.placeholderExpansion = new EzCountdownPlaceholderExpansion(this, this.countdownManager);
        this.placeholderExpansion.register();
    }

    private CountdownDefaults loadDefaults(FileConfiguration config) {
        List displayEntries = config.getStringList("defaults.display-types");
        EnumSet<DisplayType> displayTypes = EnumSet.noneOf(DisplayType.class);
        for (String entry : displayEntries) {
            try {
                displayTypes.add(DisplayType.valueOf(entry.toUpperCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException ex) {
                this.getLogger().warning("Unknown display type: " + entry);
            }
        }
        if (displayTypes.isEmpty()) {
            displayTypes.add(DisplayType.ACTION_BAR);
        }
        int updateInterval = config.getInt("defaults.update-interval", 1);
        String visibility = config.getString("defaults.visibility", "all");
        if ("all".equalsIgnoreCase(visibility)) {
            visibility = null;
        }
        String formatMessage = this.messageManager.raw("defaults.format");
        String startMessage = this.messageManager.raw("defaults.start");
        String endMessage = this.messageManager.raw("defaults.end");
        boolean startOnCreate = config.getBoolean("defaults.start-on-create", true);
        ZoneId zone = ZoneId.of(config.getString("defaults.zone", ZoneId.systemDefault().getId()));
        return new CountdownDefaults(displayTypes, updateInterval, visibility, formatMessage, startMessage, endMessage, startOnCreate, zone);
    }

    private CountdownPermissions loadPermissions(FileConfiguration config) {
        String base = config.getString("permissions.base", "ezcountdown.use");
        String create = config.getString("permissions.create", "ezcountdown.admin");
        String start = config.getString("permissions.start", "ezcountdown.admin");
        String stop = config.getString("permissions.stop", "ezcountdown.admin");
        String delete = config.getString("permissions.delete", "ezcountdown.admin");
        String list = config.getString("permissions.list", "ezcountdown.use");
        String info = config.getString("permissions.info", "ezcountdown.use");
        String reload = config.getString("permissions.reload", "ezcountdown.admin");
        return new CountdownPermissions(base, create, start, stop, delete, list, info, reload);
    }

    private void initializeMetrics() {
        try {
            Metrics metrics = new Metrics(this, 28545);
            metrics.addCustomChart(new SingleLineChart("countdown_total_count", () -> this.countdownManager == null ? 0 : this.countdownManager.getCountdownCount()));
            metrics.addCustomChart(new SingleLineChart("countdown_executed", () -> this.countdownManager == null ? 0 : this.countdownManager.getExecutedCount()));
        }
        catch (Exception ex) {
            this.getLogger().warning("Failed to start bStats metrics: " + ex.getMessage());
        }
    }

    private void ensureResource(String name) {
        File file = new File(this.getDataFolder(), name);
        if (!file.exists()) {
            this.saveResource(name, false);
        }
    }
}

