/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezboost.gui;

import com.skyblockexp.ezboost.boost.BoostDefinition;
import com.skyblockexp.ezboost.gui.ItemMetaCompat;
import java.util.ArrayList;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class BoostTokenFactory {
    private final NamespacedKey tokenKey;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public BoostTokenFactory(JavaPlugin plugin) {
        Objects.requireNonNull(plugin, "plugin");
        this.tokenKey = new NamespacedKey((Plugin)plugin, "boost-token");
    }

    public NamespacedKey tokenKey() {
        return this.tokenKey;
    }

    public ItemStack createToken(BoostDefinition boost, int amount) {
        ItemStack item = new ItemStack(Material.PAPER, amount);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        Object name = this.miniMessage.deserialize("<gold>" + boost.key().toUpperCase() + " Boost Token</gold>");
        ItemMetaCompat.setDisplayName(meta, name);
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add((Component)this.miniMessage.deserialize("<gray>Redeem to activate:</gray>"));
        lore.add((Component)this.miniMessage.deserialize(boost.displayName()));
        ItemMetaCompat.setLore(meta, lore);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        meta.getPersistentDataContainer().set(this.tokenKey, PersistentDataType.STRING, (Object)boost.key());
        item.setItemMeta(meta);
        return item;
    }
}

