/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezboost.gui;

import com.skyblockexp.ezboost.boost.BoostDefinition;
import com.skyblockexp.ezboost.boost.BoostEffect;
import com.skyblockexp.ezboost.boost.BoostManager;
import com.skyblockexp.ezboost.boost.CustomBoostEffect;
import com.skyblockexp.ezboost.config.EzBoostConfig;
import com.skyblockexp.ezboost.gui.BoostGuiHolder;
import com.skyblockexp.ezboost.gui.ItemMetaCompat;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class BoostGui {
    private final JavaPlugin plugin;
    private final BoostManager boostManager;
    private EzBoostConfig.GuiSettings settings;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    private final NamespacedKey boostKey;

    public BoostGui(JavaPlugin plugin, BoostManager boostManager, EzBoostConfig.GuiSettings settings) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.boostManager = Objects.requireNonNull(boostManager, "boostManager");
        this.settings = Objects.requireNonNull(settings, "settings");
        this.boostKey = new NamespacedKey((Plugin)plugin, "boost-key");
    }

    public void reload(EzBoostConfig.GuiSettings settings) {
        this.settings = Objects.requireNonNull(settings, "settings");
    }

    public boolean isEnabled() {
        return this.settings.enabled();
    }

    public boolean closeOnClick() {
        return this.settings.closeOnClick();
    }

    public void open(Player player) {
        if (!this.settings.enabled()) {
            return;
        }
        Object title = this.miniMessage.deserialize(this.settings.title());
        BoostGuiHolder holder = new BoostGuiHolder();
        Inventory inventory = this.createInventory(holder, (Component)title);
        holder.setInventory(inventory);
        this.fillInventory(inventory, player);
        player.openInventory(inventory);
    }

    public void refresh(Player player, Inventory inventory) {
        this.fillInventory(inventory, player);
    }

    public NamespacedKey boostKey() {
        return this.boostKey;
    }

    private void fillInventory(Inventory inventory, Player player) {
        inventory.clear();
        this.fillFiller(inventory);
        Map<String, BoostDefinition> boosts = this.boostManager.getBoosts(player);
        for (Map.Entry<String, BoostDefinition> entry : boosts.entrySet()) {
            String key = entry.getKey().toLowerCase(Locale.ROOT);
            Integer slot = this.settings.slots().get(key);
            if (slot == null || slot < 0 || slot >= inventory.getSize()) continue;
            inventory.setItem(slot.intValue(), this.createBoostItem(player, entry.getValue()));
        }
    }

    private void fillFiller(Inventory inventory) {
        EzBoostConfig.FillerItem filler = this.settings.filler();
        if (filler == null || filler.material() == Material.AIR) {
            return;
        }
        ItemStack item = new ItemStack(filler.material());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ItemMetaCompat.setDisplayName(meta, this.miniMessage.deserialize(filler.name()));
            if (filler.lore() != null && !filler.lore().isEmpty()) {
                ArrayList<Component> lore = new ArrayList<Component>();
                for (String line : filler.lore()) {
                    lore.add((Component)this.miniMessage.deserialize(line));
                }
                ItemMetaCompat.setLore(meta, lore);
            }
            item.setItemMeta(meta);
        }
        int i = 0;
        while (i < inventory.getSize()) {
            if (inventory.getItem(i) == null) {
                inventory.setItem(i, item);
            }
            ++i;
        }
    }

    private ItemStack createBoostItem(Player player, BoostDefinition boost) {
        ItemStack item = new ItemStack(boost.icon());
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        ItemMetaCompat.setDisplayName(meta, this.miniMessage.deserialize(boost.displayName()));
        ArrayList<Component> lore = new ArrayList<Component>();
        for (BoostEffect effect : boost.effects()) {
            if (effect.type() != null) {
                lore.add(Component.text("Effect: " + effect.type().getName() + " (" + effect.amplifier() + ")"));
                continue;
            }
            for (CustomBoostEffect custom : this.boostManager.getCustomEffects().values()) {
                lore.add(Component.text("Effect: " + custom.getName() + " (" + effect.amplifier() + ")"));
            }
        }
        String status = this.statusFor(player, boost);
        for (String line : this.settings.loreLines()) {
            lore.add(this.miniMessage.deserialize(line, Placeholder.parsed("duration", String.valueOf(boost.durationSeconds())), Placeholder.parsed("cooldown", String.valueOf(boost.cooldownSeconds())), Placeholder.parsed("cost", this.formatCost(boost.cost())), Placeholder.parsed("status", status)));
        }
        ItemMetaCompat.setLore(meta, lore);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS});
        meta.getPersistentDataContainer().set(this.boostKey, PersistentDataType.STRING, (Object)boost.key());
        item.setItemMeta(meta);
        return item;
    }

    private String statusFor(Player player, BoostDefinition boost) {
        if (!boost.enabled()) {
            return this.settings.status("locked", "Locked");
        }
        if (boost.permission() != null && !boost.permission().isBlank() && !player.hasPermission(boost.permission())) {
            return this.settings.status("locked", "Locked");
        }
        if (this.boostManager.isActive(player, boost.key())) {
            return this.settings.status("active", "Active");
        }
        long cooldown = this.boostManager.getCooldownRemaining(player, boost.key());
        if (cooldown > 0L) {
            return this.settings.status("cooldown", "Cooldown");
        }
        return this.settings.status("available", "Available");
    }

    private String formatCost(double cost) {
        if (cost <= 0.0) {
            return "Free";
        }
        if (cost == Math.floor(cost)) {
            return String.valueOf((int)cost);
        }
        return String.format(Locale.US, "%.2f", cost);
    }

    private Inventory createInventory(BoostGuiHolder holder, Component title) {
        try {
            Method method = Bukkit.class.getMethod("createInventory", InventoryHolder.class, Integer.TYPE, Component.class);
            return (Inventory)method.invoke(null, holder, this.settings.size(), title);
        }
        catch (NoSuchMethodException e) {
            String legacyTitle = this.legacySerializer.serialize(title);
            return Bukkit.createInventory((InventoryHolder)holder, (int)this.settings.size(), (String)legacyTitle);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create boost inventory", e);
        }
    }
}

