/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezboost.economy;

import com.skyblockexp.ezboost.config.EzBoostConfig;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public final class EconomyService {
    private Economy economy;
    private boolean enabled;

    public void setup(EzBoostConfig.EconomySettings settings) {
        this.enabled = settings != null && settings.enabled();
        this.economy = null;
        if (!this.enabled || settings == null || !settings.vaultEnabled()) {
            return;
        }
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (provider != null) {
            this.economy = (Economy)provider.getProvider();
        }
    }

    public boolean isAvailable() {
        return this.enabled && this.economy != null;
    }

    public EconomyResponse withdraw(Player player, double amount) {
        if (!this.isAvailable()) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, "Economy unavailable");
        }
        return this.economy.withdrawPlayer((OfflinePlayer)player, amount);
    }

    public void deposit(Player player, double amount) {
        if (this.isAvailable()) {
            this.economy.depositPlayer((OfflinePlayer)player, amount);
        }
    }
}

