/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezboost.config;

import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MultiFileConfigLoader {
    private final JavaPlugin plugin;
    private final String[] configFiles;

    public MultiFileConfigLoader(JavaPlugin plugin, String ... configFiles) {
        this.plugin = plugin;
        this.configFiles = configFiles;
    }

    public FileConfiguration loadMerged() {
        YamlConfiguration merged = new YamlConfiguration();
        for (String fileName : this.configFiles) {
            File file = new File(this.plugin.getDataFolder(), fileName);
            if (!file.exists()) {
                this.plugin.saveResource(fileName, false);
            }
            YamlConfiguration part = YamlConfiguration.loadConfiguration((File)file);
            this.mergeSections((FileConfiguration)merged, (FileConfiguration)part);
        }
        return merged;
    }

    private void mergeSections(FileConfiguration target, FileConfiguration source) {
        for (String key : source.getKeys(true)) {
            Object value = source.get(key);
            target.set(key, value);
        }
    }
}

