/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezboost.config;

import java.io.File;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class Messages {
    private final JavaPlugin plugin;
    private FileConfiguration configuration;
    private String prefix;
    private boolean actionbarEnabled;
    private String actionbarFormat;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build();

    public Messages(JavaPlugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.reload();
    }

    public void reload() {
        File file = new File(this.plugin.getDataFolder(), "messages.yml");
        this.configuration = YamlConfiguration.loadConfiguration((File)file);
        this.prefix = this.configuration.getString("prefix", "");
        this.actionbarEnabled = this.configuration.getBoolean("actionbar.enabled", false);
        this.actionbarFormat = this.configuration.getString("actionbar.format", "<boost> <time>");
    }

    public String message(String key, TagResolver ... resolvers) {
        String raw = this.configuration.getString(key, "");
        return this.legacySerialize(this.prefix + raw, resolvers);
    }

    public String plain(String key, TagResolver ... resolvers) {
        String raw = this.configuration.getString(key, "");
        return this.legacySerialize(raw, resolvers);
    }

    public boolean actionbarEnabled() {
        return this.actionbarEnabled;
    }

    public String actionbar(String boostName, long timeSeconds) {
        return this.legacySerialize(this.actionbarFormat, TagResolver.resolver(Placeholder.parsed("boost", boostName), Placeholder.parsed("time", String.valueOf(timeSeconds))));
    }

    private String legacySerialize(String input, TagResolver ... resolvers) {
        Component component = this.miniMessage.deserialize(input, resolvers);
        String legacy = this.legacySerializer.serialize(component);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)legacy);
    }
}

