/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezboost.config;

import com.skyblockexp.ezboost.api.EzBoostAPI;
import com.skyblockexp.ezboost.boost.BoostCommands;
import com.skyblockexp.ezboost.boost.BoostDefinition;
import com.skyblockexp.ezboost.boost.BoostEffect;
import com.skyblockexp.ezboost.boost.BoostManager;
import com.skyblockexp.ezboost.boost.CustomBoostEffect;
import com.skyblockexp.ezboost.config.MultiFileConfigLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;

public final class EzBoostConfig {
    private static final Material DEFAULT_ICON = Material.NETHER_STAR;
    private final JavaPlugin plugin;
    private final Logger logger;
    private Settings settings;
    private Limits limits;
    private WorldSettings worldSettings;
    private EconomySettings economySettings;
    private GuiSettings guiSettings;
    private Map<String, BoostDefinition> boosts = new LinkedHashMap<String, BoostDefinition>();
    private Map<String, List<String>> worldGroups = new HashMap<String, List<String>>();
    private Map<String, Object> boostOverrides = new HashMap<String, Object>();

    public EzBoostConfig(JavaPlugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.logger = plugin.getLogger();
        this.reload();
    }

    public void reload() {
        FileConfiguration config = new MultiFileConfigLoader(this.plugin, "settings.yml", "limits.yml", "worlds.yml", "economy.yml", "gui.yml", "boosts.yml").loadMerged();
        this.settings = new Settings(config.getBoolean("settings.replace-active-boost", false), config.getBoolean("settings.refund-on-fail", true), config.getBoolean("settings.keep-boost-on-death", true), config.getBoolean("settings.reapply-on-join", true), config.getBoolean("settings.send-expired-message", true), config.getBoolean("settings.cooldown-per-boost-type", true));
        this.limits = new Limits(config.getInt("limits.duration-min", 5), config.getInt("limits.duration-max", 3600), config.getInt("limits.amplifier-min", 0), config.getInt("limits.amplifier-max", 5));
        this.worldSettings = new WorldSettings(config.getStringList("worlds.allow-list"), config.getStringList("worlds.deny-list"));
        this.economySettings = new EconomySettings(config.getBoolean("economy.enabled", true), config.getBoolean("economy.vault", true));
        this.guiSettings = this.loadGuiSettings(config.getConfigurationSection("gui"));
        this.boosts = this.loadBoosts(config.getConfigurationSection("boosts"));
        this.worldGroups.clear();
        ConfigurationSection worldGroupsSection = config.getConfigurationSection("worldgroups");
        if (worldGroupsSection != null) {
            for (String group : worldGroupsSection.getKeys(false)) {
                this.worldGroups.put(group.toLowerCase(Locale.ROOT), worldGroupsSection.getStringList(group));
            }
        }
        this.boostOverrides.clear();
        ConfigurationSection overridesSection = config.getConfigurationSection("overrides");
        if (overridesSection != null) {
            for (String type : List.of("regions", "worlds", "worldgroups")) {
                ConfigurationSection typeSection = overridesSection.getConfigurationSection(type);
                if (typeSection == null) continue;
                HashMap<String, ConfigurationSection> typeMap = new HashMap<String, ConfigurationSection>();
                for (String name : typeSection.getKeys(false)) {
                    typeMap.put(name.toLowerCase(Locale.ROOT), typeSection.getConfigurationSection(name));
                }
                this.boostOverrides.put(type, typeMap);
            }
        }
    }

    public BoostDefinition getEffectiveBoost(String boostKey, String worldName, String regionName) {
        ConfigurationSection worldSection;
        ConfigurationSection boostOverride;
        ConfigurationSection regionSection;
        Map regionsMap;
        String key = boostKey.toLowerCase(Locale.ROOT);
        BoostDefinition base = this.boosts.get(key);
        if (base == null) {
            return null;
        }
        if (regionName != null && (regionsMap = (Map)this.boostOverrides.get("regions")) != null && (regionSection = (ConfigurationSection)regionsMap.get(regionName.toLowerCase(Locale.ROOT))) != null && (boostOverride = regionSection.getConfigurationSection(key)) != null) {
            return this.mergeBoostOverride(base, boostOverride);
        }
        Map worldsMap = (Map)this.boostOverrides.get("worlds");
        if (worldsMap != null && (worldSection = (ConfigurationSection)worldsMap.get(worldName.toLowerCase(Locale.ROOT))) != null && (boostOverride = worldSection.getConfigurationSection(key)) != null) {
            return this.mergeBoostOverride(base, boostOverride);
        }
        Map groupsMap = (Map)this.boostOverrides.get("worldgroups");
        if (groupsMap != null) {
            for (Map.Entry<String, List<String>> entry : this.worldGroups.entrySet()) {
                ConfigurationSection boostOverride2;
                ConfigurationSection groupSection;
                if (!entry.getValue().stream().anyMatch(w -> w.equalsIgnoreCase(worldName)) || (groupSection = (ConfigurationSection)groupsMap.get(entry.getKey())) == null || (boostOverride2 = groupSection.getConfigurationSection(key)) == null) continue;
                return this.mergeBoostOverride(base, boostOverride2);
            }
        }
        return base;
    }

    public BoostDefinition getEffectiveBoost(String boostKey, String worldName) {
        return this.getEffectiveBoost(boostKey, worldName, null);
    }

    private BoostDefinition mergeBoostOverride(BoostDefinition base, ConfigurationSection override) {
        String displayName = override.contains("display-name") ? override.getString("display-name") : base.displayName();
        Material icon = override.contains("icon") ? this.resolveMaterial(override.getString("icon"), base.icon()) : base.icon();
        List<BoostEffect> effects = base.effects();
        if (override.contains("effects")) {
            List effectsConfig = override.getMapList("effects");
            ArrayList<BoostEffect> newEffects = new ArrayList<BoostEffect>();
            for (Map entry : effectsConfig) {
                String typeName;
                PotionEffectType type;
                if (entry == null || (type = PotionEffectType.getByName((String)(typeName = Objects.toString(entry.get("type"), "")).toUpperCase(Locale.ROOT))) == null) continue;
                int amplifier = this.readInt(entry.get("amplifier"), 0);
                amplifier = this.clamp(amplifier, this.limits.amplifierMin(), this.limits.amplifierMax());
                newEffects.add(new BoostEffect(type, amplifier));
            }
            if (!newEffects.isEmpty()) {
                effects = newEffects;
            }
        }
        BoostCommands commands = base.commands();
        if (override.contains("commands")) {
            commands = this.readBoostCommands(override.getConfigurationSection("commands"));
        }
        int duration = override.contains("duration") ? this.clamp(override.getInt("duration"), this.limits.durationMin(), this.limits.durationMax()) : base.durationSeconds();
        int cooldown = override.contains("cooldown") ? override.getInt("cooldown") : base.cooldownSeconds();
        double cost = override.contains("cost") ? override.getDouble("cost") : base.cost();
        String permission = override.contains("permission") ? override.getString("permission") : base.permission();
        boolean enabled = override.contains("enabled") ? override.getBoolean("enabled") : base.enabled();
        return new BoostDefinition(base.key(), displayName, icon, effects, commands, duration, cooldown, cost, permission, enabled);
    }

    public Settings settings() {
        return this.settings;
    }

    public Limits limits() {
        return this.limits;
    }

    public WorldSettings worldSettings() {
        return this.worldSettings;
    }

    public EconomySettings economySettings() {
        return this.economySettings;
    }

    public GuiSettings guiSettings() {
        return this.guiSettings;
    }

    public Map<String, BoostDefinition> boosts() {
        return this.boosts;
    }

    private GuiSettings loadGuiSettings(ConfigurationSection section) {
        if (section == null) {
            return GuiSettings.disabled();
        }
        boolean enabled = section.getBoolean("enabled", true);
        String title = section.getString("title", "EzBoost");
        int size = Math.max(9, Math.min(54, section.getInt("size", 45)));
        boolean closeOnClick = section.getBoolean("close-on-click", true);
        ConfigurationSection fillerSection = section.getConfigurationSection("filler");
        FillerItem filler = null;
        if (fillerSection != null) {
            Material material = this.resolveMaterial(fillerSection.getString("material"), Material.BLACK_STAINED_GLASS_PANE);
            String name = fillerSection.getString("name", " ");
            List lore = fillerSection.getStringList("lore");
            filler = new FillerItem(material, name, lore);
        }
        List loreLines = section.getStringList("lore");
        HashMap<String, String> status = new HashMap<String, String>();
        ConfigurationSection statusSection = section.getConfigurationSection("status");
        if (statusSection != null) {
            for (String key : statusSection.getKeys(false)) {
                status.put(key.toLowerCase(Locale.ROOT), statusSection.getString(key, ""));
            }
        }
        HashMap<String, Integer> slots = new HashMap<String, Integer>();
        ConfigurationSection slotsSection = section.getConfigurationSection("slots");
        if (slotsSection != null) {
            for (String key : slotsSection.getKeys(false)) {
                slots.put(key.toLowerCase(Locale.ROOT), slotsSection.getInt(key));
            }
        }
        return new GuiSettings(enabled, title, size, closeOnClick, filler, loreLines, status, slots);
    }

    private Map<String, BoostDefinition> loadBoosts(ConfigurationSection boostsSection) {
        if (boostsSection == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, BoostDefinition> loaded = new LinkedHashMap<String, BoostDefinition>();
        BoostManager boostManager = EzBoostAPI.getBoostManager();
        for (String key : boostsSection.getKeys(false)) {
            ConfigurationSection boostSection = boostsSection.getConfigurationSection(key);
            if (boostSection == null) continue;
            String normalizedKey = key.toLowerCase(Locale.ROOT);
            String displayName = boostSection.getString("display-name", normalizedKey);
            Material icon = this.resolveMaterial(boostSection.getString("icon"), DEFAULT_ICON);
            List effectsConfig = boostSection.getMapList("effects");
            ArrayList<BoostEffect> effects = new ArrayList<BoostEffect>();
            for (Map entry : effectsConfig) {
                if (entry == null) continue;
                String typeName = Objects.toString(entry.get("type"), "");
                PotionEffectType type = PotionEffectType.getByName((String)typeName.toUpperCase(Locale.ROOT));
                if (type != null) {
                    int amplifier = this.readInt(entry.get("amplifier"), 0);
                    amplifier = this.clamp(amplifier, this.limits.amplifierMin(), this.limits.amplifierMax());
                    effects.add(new BoostEffect(type, amplifier));
                    continue;
                }
                if (boostManager != null) {
                    CustomBoostEffect custom = boostManager.getCustomEffect(typeName);
                    if (custom != null) {
                        int amplifier = this.readInt(entry.get("amplifier"), 0);
                        effects.add(new BoostEffect(null, amplifier));
                        continue;
                    }
                    this.logger.warning("EzBoost: Unknown effect type '" + typeName + "' for boost " + normalizedKey + ".");
                    continue;
                }
                this.logger.warning("EzBoost: Unknown effect type '" + typeName + "' for boost " + normalizedKey + ".");
            }
            if (effects.isEmpty()) {
                this.logger.warning("EzBoost: Boost " + normalizedKey + " has no valid effects and will be skipped.");
                continue;
            }
            BoostCommands commands = this.readBoostCommands(boostSection);
            int duration = boostSection.getInt("duration", 60);
            duration = this.clamp(duration, this.limits.durationMin(), this.limits.durationMax());
            int cooldown = boostSection.getInt("cooldown", 0);
            double cost = boostSection.getDouble("cost", 0.0);
            String permission = boostSection.getString("permission", null);
            boolean enabled = boostSection.getBoolean("enabled", true);
            loaded.put(normalizedKey, new BoostDefinition(normalizedKey, displayName, icon, effects, commands, duration, cooldown, cost, permission, enabled));
        }
        return loaded;
    }

    private BoostCommands readBoostCommands(ConfigurationSection boostSection) {
        List enable = boostSection.getStringList("commands.enable");
        List disable = boostSection.getStringList("commands.disable");
        List toggle = boostSection.getStringList("commands.toggle");
        if (boostSection.isList("commands")) {
            toggle = boostSection.getStringList("commands");
        }
        return new BoostCommands(enable, disable, toggle);
    }

    public String getWorldGroup(String worldName) {
        for (Map.Entry<String, List<String>> entry : this.worldGroups.entrySet()) {
            if (!entry.getValue().stream().anyMatch(w -> w.equalsIgnoreCase(worldName))) continue;
            return entry.getKey();
        }
        return null;
    }

    private Material resolveMaterial(String name, Material fallback) {
        if (name == null || name.isBlank()) {
            return fallback;
        }
        Material material = Material.matchMaterial((String)name.toUpperCase(Locale.ROOT));
        if (material == null) {
            this.logger.warning("EzBoost: Invalid material '" + name + "', using " + String.valueOf(fallback) + ".");
            return fallback;
        }
        return material;
    }

    private int clamp(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    private int readInt(Object value, int fallback) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        if (value instanceof String) {
            String text = (String)value;
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException ignored) {
                return fallback;
            }
        }
        return fallback;
    }

    public record EconomySettings(boolean enabled, boolean vaultEnabled) {
    }

    public record FillerItem(Material material, String name, List<String> lore) {
    }

    public record GuiSettings(boolean enabled, String title, int size, boolean closeOnClick, FillerItem filler, List<String> loreLines, Map<String, String> statusLabels, Map<String, Integer> slots) {
        public static GuiSettings disabled() {
            return new GuiSettings(false, "EzBoost", 9, true, null, List.of(), Map.of(), Map.of());
        }

        public String status(String key, String fallback) {
            return this.statusLabels.getOrDefault(key, fallback);
        }
    }

    public record Limits(int durationMin, int durationMax, int amplifierMin, int amplifierMax) {
    }

    public record Settings(boolean replaceActiveBoost, boolean refundOnFail, boolean keepBoostOnDeath, boolean reapplyOnJoin, boolean sendExpiredMessage, boolean cooldownPerBoostType) {
    }

    public record WorldSettings(List<String> allowList, List<String> denyList) {
        public boolean isAllowed(String worldName) {
            boolean allowed;
            String normalized = worldName.toLowerCase(Locale.ROOT);
            if (!this.allowList.isEmpty() && !(allowed = this.allowList.stream().map(name -> name.toLowerCase(Locale.ROOT)).anyMatch(name -> name.equals(normalized)))) {
                return false;
            }
            return this.denyList.stream().map(name -> name.toLowerCase(Locale.ROOT)).noneMatch(name -> name.equals(normalized));
        }
    }
}

