/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezboost.command;

import com.skyblockexp.ezboost.boost.BoostDefinition;
import com.skyblockexp.ezboost.boost.BoostManager;
import com.skyblockexp.ezboost.config.Messages;
import com.skyblockexp.ezboost.gui.BoostTokenFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class EzBoostCommand
implements CommandExecutor,
TabCompleter {
    private final BoostManager boostManager;
    private final Messages messages;
    private final BoostTokenFactory tokenFactory;
    private final Runnable reloadAction;

    public EzBoostCommand(BoostManager boostManager, Messages messages, BoostTokenFactory tokenFactory, Runnable reloadAction) {
        this.boostManager = Objects.requireNonNull(boostManager, "boostManager");
        this.messages = Objects.requireNonNull(messages, "messages");
        this.tokenFactory = Objects.requireNonNull(tokenFactory, "tokenFactory");
        this.reloadAction = Objects.requireNonNull(reloadAction, "reloadAction");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("Usage: /ezboost reload|give <player> <boostKey> [amount]");
            return true;
        }
        String sub = args[0].toLowerCase(Locale.ROOT);
        if (sub.equals("reload")) {
            if (!sender.hasPermission("ezboost.reload")) {
                sender.sendMessage(this.messages.message("no-permission", new TagResolver[0]));
                return true;
            }
            this.reloadAction.run();
            sender.sendMessage(this.messages.message("reload", new TagResolver[0]));
            return true;
        }
        if (sub.equals("give")) {
            if (!sender.hasPermission("ezboost.give")) {
                sender.sendMessage(this.messages.message("no-permission", new TagResolver[0]));
                return true;
            }
            if (args.length < 3) {
                sender.sendMessage("Usage: /ezboost give <player> <boostKey> [amount]");
                return true;
            }
            Player target = Bukkit.getPlayerExact((String)args[1]);
            if (target == null) {
                sender.sendMessage(this.messages.message("invalid-target", new TagResolver[0]));
                return true;
            }
            String boostKey = args[2].toLowerCase(Locale.ROOT);
            BoostDefinition definition = this.boostManager.getBoost(boostKey, target).orElse(null);
            if (definition == null) {
                sender.sendMessage(this.messages.message("boost-not-found", new TagResolver[0]));
                return true;
            }
            int amount = 1;
            if (args.length > 3) {
                try {
                    amount = Integer.parseInt(args[3]);
                }
                catch (NumberFormatException ignored) {
                    amount = 1;
                }
            }
            if (amount <= 0) {
                amount = 1;
            }
            ItemStack item = this.tokenFactory.createToken(definition, amount);
            target.getInventory().addItem(new ItemStack[]{item});
            sender.sendMessage(this.messages.message("token-given", Placeholder.parsed("player", target.getName()), Placeholder.parsed("boost", definition.key()), Placeholder.parsed("amount", String.valueOf(amount))));
            return true;
        }
        sender.sendMessage("Usage: /ezboost reload|give <player> <boostKey> [amount]");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return List.of("reload", "give");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("give")) {
            ArrayList<String> names = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                names.add(player.getName());
            }
            return names;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("give") && sender instanceof Player) {
            return new ArrayList<String>(this.boostManager.getBoosts((Player)sender).keySet());
        }
        return List.of();
    }
}

