/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezboost.command;

import com.skyblockexp.ezboost.boost.BoostManager;
import com.skyblockexp.ezboost.config.Messages;
import com.skyblockexp.ezboost.gui.BoostGui;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public final class BoostCommand
implements CommandExecutor,
TabCompleter {
    private final BoostManager boostManager;
    private final BoostGui boostGui;
    private final Messages messages;

    public BoostCommand(BoostManager boostManager, BoostGui boostGui, Messages messages) {
        this.boostManager = Objects.requireNonNull(boostManager, "boostManager");
        this.boostGui = Objects.requireNonNull(boostGui, "boostGui");
        this.messages = Objects.requireNonNull(messages, "messages");
    }

    /*
     * WARNING - void declaration
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        void player;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.message("only-players", new TagResolver[0]));
            return true;
        }
        Player player2 = (Player)sender;
        if (args.length == 0) {
            if (this.boostGui.isEnabled()) {
                this.boostGui.open((Player)player);
            } else {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /boost <boostKey>");
            }
            return true;
        }
        String boostKey = args[0].toLowerCase(Locale.ROOT);
        this.boostManager.activate((Player)player, boostKey, BoostManager.ActivationSource.COMMAND);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1 && sender instanceof Player) {
            String prefix = args[0].toLowerCase(Locale.ROOT);
            ArrayList<String> completions = new ArrayList<String>();
            for (String key : this.boostManager.getBoosts((Player)sender).keySet()) {
                if (!key.startsWith(prefix)) continue;
                completions.add(key);
            }
            return completions;
        }
        return List.of();
    }
}

