/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezboost.boost;

import com.skyblockexp.ezboost.boost.BoostDefinition;
import com.skyblockexp.ezboost.boost.BoostEffect;
import com.skyblockexp.ezboost.boost.BoostState;
import com.skyblockexp.ezboost.boost.CustomBoostEffect;
import com.skyblockexp.ezboost.boost.WorldGuardHelper;
import com.skyblockexp.ezboost.config.EzBoostConfig;
import com.skyblockexp.ezboost.config.Messages;
import com.skyblockexp.ezboost.economy.EconomyService;
import com.skyblockexp.ezboost.event.BoostEndEvent;
import com.skyblockexp.ezboost.event.BoostStartEvent;
import com.skyblockexp.ezboost.storage.BoostStorage;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitTask;

public final class BoostManager {
    private static final String GLOBAL_COOLDOWN_KEY = "global";
    private final JavaPlugin plugin;
    private EzBoostConfig config;
    private Messages messages;
    private EconomyService economyService;
    private final BoostStorage storage;
    private final Logger logger;
    private final Map<UUID, BoostState> states = new ConcurrentHashMap<UUID, BoostState>();
    private final Map<UUID, BukkitTask> expiryTasks = new HashMap<UUID, BukkitTask>();
    private final Map<UUID, BukkitTask> actionbarTasks = new HashMap<UUID, BukkitTask>();
    private final ConcurrentMap<String, CustomBoostEffect> customEffects = new ConcurrentHashMap<String, CustomBoostEffect>();

    public boolean registerCustomEffect(CustomBoostEffect effect) {
        Objects.requireNonNull(effect, "effect");
        String name = effect.getName().toLowerCase(Locale.ROOT);
        if (this.customEffects.containsKey(name)) {
            return false;
        }
        this.customEffects.put(name, effect);
        this.logger.info("Registered custom boost effect: " + name);
        return true;
    }

    public CustomBoostEffect getCustomEffect(String name) {
        return (CustomBoostEffect)this.customEffects.get(name.toLowerCase(Locale.ROOT));
    }

    public Map<String, CustomBoostEffect> getCustomEffects() {
        return Collections.unmodifiableMap(this.customEffects);
    }

    public BoostManager(JavaPlugin plugin, EzBoostConfig config, Messages messages, EconomyService economyService, BoostStorage storage) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.config = Objects.requireNonNull(config, "config");
        this.messages = Objects.requireNonNull(messages, "messages");
        this.economyService = Objects.requireNonNull(economyService, "economyService");
        this.storage = Objects.requireNonNull(storage, "storage");
        this.logger = plugin.getLogger();
    }

    public void loadStates() {
        this.states.clear();
        this.states.putAll(this.storage.load());
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.handleJoin(player);
        }
    }

    public void saveStates() {
        this.storage.save(this.states);
    }

    public void reload(EzBoostConfig config, Messages messages, EconomyService economyService) {
        this.config = config;
        this.messages = messages;
        this.economyService = economyService;
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.refreshPlayer(player);
        }
    }

    public Optional<BoostDefinition> getBoost(String key, Player player) {
        if (key == null || player == null) {
            return Optional.empty();
        }
        String region = WorldGuardHelper.getHighestPriorityRegion(player);
        BoostDefinition def = this.config.getEffectiveBoost(key, player.getWorld().getName(), region);
        return Optional.ofNullable(def);
    }

    public Map<String, BoostDefinition> getBoosts(Player player) {
        String region = WorldGuardHelper.getHighestPriorityRegion(player);
        HashMap<String, BoostDefinition> result = new HashMap<String, BoostDefinition>();
        for (String key : this.config.boosts().keySet()) {
            BoostDefinition def = this.config.getEffectiveBoost(key, player.getWorld().getName(), region);
            if (def == null) continue;
            result.put(key, def);
        }
        return result;
    }

    public boolean isActive(Player player, String boostKey) {
        BoostState state = this.states.get(player.getUniqueId());
        return state != null && boostKey.equalsIgnoreCase(state.activeBoostKey()) && state.endTimestamp() > System.currentTimeMillis();
    }

    public long getCooldownRemaining(Player player, String boostKey) {
        BoostState state = this.states.get(player.getUniqueId());
        if (state == null) {
            return 0L;
        }
        long remaining = state.cooldownEnd(this.cooldownKey(boostKey)) - System.currentTimeMillis();
        return Math.max(0L, remaining / 1000L);
    }

    public boolean activate(Player player, String boostKey, ActivationSource source) {
        Optional<BoostDefinition> definition = this.getBoost(boostKey, player);
        if (definition.isEmpty()) {
            player.sendMessage(this.messages.message("boost-not-found", new TagResolver[0]));
            return false;
        }
        return this.activate(player, definition.get(), source);
    }

    public boolean activate(Player player, BoostDefinition boost, ActivationSource source) {
        long cooldownEnd;
        String region = WorldGuardHelper.getHighestPriorityRegion(player);
        BoostDefinition effective = this.config.getEffectiveBoost(boost.key(), player.getWorld().getName(), region);
        if (effective == null) {
            player.sendMessage(this.messages.message("boost-not-found", new TagResolver[0]));
            return false;
        }
        if (!effective.enabled()) {
            player.sendMessage(this.messages.message("boost-disabled", new TagResolver[0]));
            return false;
        }
        if (!this.config.worldSettings().isAllowed(player.getWorld().getName())) {
            player.sendMessage(this.messages.message("world-blocked", new TagResolver[0]));
            return false;
        }
        if (effective.permission() != null && !effective.permission().isBlank() && !player.hasPermission(effective.permission())) {
            player.sendMessage(this.messages.message("no-permission", new TagResolver[0]));
            return false;
        }
        BoostState state = this.states.computeIfAbsent(player.getUniqueId(), id -> new BoostState());
        long now = System.currentTimeMillis();
        if (state.activeBoostKey() != null && state.endTimestamp() > now) {
            boolean canReplace;
            if (state.activeBoostKey().equalsIgnoreCase(effective.key())) {
                player.sendMessage(this.messages.message("boost-active", new TagResolver[0]));
                return false;
            }
            boolean bl = canReplace = this.config.settings().replaceActiveBoost() || this.config.settings().cooldownPerBoostType();
            if (!canReplace) {
                player.sendMessage(this.messages.message("boost-active", new TagResolver[0]));
                return false;
            }
            this.clearActiveBoost(player, state, false);
            player.sendMessage(this.messages.message("boost-replaced", new TagResolver[0]));
        }
        if (!player.hasPermission("ezboost.cooldown.bypass") && (cooldownEnd = state.cooldownEnd(this.cooldownKey(effective.key()))) > now) {
            long remaining = Math.max(0L, (cooldownEnd - now) / 1000L);
            player.sendMessage(this.messages.message("boost-cooldown", Placeholder.parsed("time", String.valueOf(remaining))));
            return false;
        }
        double cost = effective.cost();
        EzBoostConfig.EconomySettings economySettings = this.config.economySettings();
        if (cost > 0.0 && economySettings != null && economySettings.enabled() && !this.economyService.isAvailable()) {
            player.sendMessage(this.messages.message("economy-unavailable", new TagResolver[0]));
            this.logger.warning("EzBoost economy is enabled but Vault is unavailable; blocking boost activation.");
            return false;
        }
        boolean charged = false;
        if (cost > 0.0 && this.economyService.isAvailable()) {
            EconomyResponse response = this.economyService.withdraw(player, cost);
            if (!response.transactionSuccess()) {
                player.sendMessage(this.messages.message("insufficient-funds", Placeholder.parsed("cost", this.formatCost(cost))));
                return false;
            }
            charged = true;
        }
        try {
            this.applyBoost(player, effective);
        }
        catch (Exception ex) {
            this.logger.warning("EzBoost failed to apply boost " + effective.key() + ": " + ex.getMessage());
            if (charged && this.config.settings().refundOnFail()) {
                this.economyService.deposit(player, cost);
            }
            return false;
        }
        BoostStartEvent startEvent = new BoostStartEvent(player, effective.key(), effective);
        Bukkit.getPluginManager().callEvent((Event)startEvent);
        if (startEvent.isCancelled()) {
            return false;
        }
        long endTimestamp = now + (long)effective.durationSeconds() * 1000L;
        state.setActiveBoost(effective.key(), endTimestamp);
        if (effective.cooldownSeconds() > 0) {
            state.setCooldownEnd(this.cooldownKey(effective.key()), now + (long)effective.cooldownSeconds() * 1000L);
        }
        this.scheduleExpiry(player, effective, endTimestamp);
        this.scheduleActionbar(player, effective);
        this.runEnableCommands(player, effective);
        player.sendMessage(this.messages.message("boost-activated", Placeholder.parsed("boost", effective.displayName())));
        if (charged) {
            player.sendMessage(this.messages.message("cost-charged", Placeholder.parsed("boost", effective.key()), Placeholder.parsed("cost", this.formatCost(cost))));
        }
        if (source == ActivationSource.TOKEN) {
            player.sendMessage(this.messages.message("token-used", Placeholder.parsed("boost", effective.key())));
        }
        this.saveStates();
        return true;
    }

    public void handleJoin(Player player) {
        BoostState state = this.states.computeIfAbsent(player.getUniqueId(), id -> new BoostState());
        if (state.activeBoostKey() == null) {
            return;
        }
        String region = WorldGuardHelper.getHighestPriorityRegion(player);
        BoostDefinition definition = this.config.getEffectiveBoost(state.activeBoostKey(), player.getWorld().getName(), region);
        long now = System.currentTimeMillis();
        if (definition == null || state.endTimestamp() <= now) {
            state.clearActiveBoost();
            this.saveStates();
            return;
        }
        if (!this.config.settings().reapplyOnJoin()) {
            return;
        }
        BoostStartEvent startEvent = new BoostStartEvent(player, definition.key(), definition);
        Bukkit.getPluginManager().callEvent((Event)startEvent);
        if (startEvent.isCancelled()) {
            return;
        }
        this.applyBoost(player, definition, (int)Math.max(1L, (state.endTimestamp() - now) / 1000L));
        this.runEnableCommands(player, definition);
        this.scheduleExpiry(player, definition, state.endTimestamp());
        this.scheduleActionbar(player, definition);
    }

    public void handleQuit(Player player) {
        this.cancelExpiryTask(player.getUniqueId());
        this.cancelActionbarTask(player.getUniqueId());
    }

    public void handleDeath(Player player) {
        if (this.config.settings().keepBoostOnDeath()) {
            return;
        }
        BoostState state = this.states.get(player.getUniqueId());
        if (state == null || state.activeBoostKey() == null) {
            return;
        }
        String region = WorldGuardHelper.getHighestPriorityRegion(player);
        BoostDefinition definition = this.config.getEffectiveBoost(state.activeBoostKey(), player.getWorld().getName(), region);
        BoostEndEvent endEvent = new BoostEndEvent(player, state.activeBoostKey(), definition);
        Bukkit.getPluginManager().callEvent((Event)endEvent);
        if (!endEvent.isCancelled()) {
            this.clearActiveBoost(player, state, true);
            this.saveStates();
        }
    }

    private void refreshPlayer(Player player) {
        BoostState state = this.states.get(player.getUniqueId());
        if (state == null || state.activeBoostKey() == null) {
            return;
        }
        String region = WorldGuardHelper.getHighestPriorityRegion(player);
        BoostDefinition definition = this.config.getEffectiveBoost(state.activeBoostKey(), player.getWorld().getName(), region);
        if (definition == null || !definition.enabled()) {
            BoostEndEvent endEvent = new BoostEndEvent(player, state.activeBoostKey(), definition);
            Bukkit.getPluginManager().callEvent((Event)endEvent);
            if (!endEvent.isCancelled()) {
                this.clearActiveBoost(player, state, true);
                this.saveStates();
            }
        }
    }

    private void applyBoost(Player player, BoostDefinition boost) {
        this.applyBoost(player, boost, boost.durationSeconds());
    }

    private void applyBoost(Player player, BoostDefinition boost, int durationSeconds) {
        for (BoostEffect effect : boost.effects()) {
            if (effect.type() != null) {
                PotionEffect potionEffect = new PotionEffect(effect.type(), durationSeconds * 20, effect.amplifier(), false, true, true);
                player.addPotionEffect(potionEffect, true);
                continue;
            }
            for (CustomBoostEffect custom : this.customEffects.values()) {
                if (custom == null) continue;
                custom.apply(player, effect.amplifier());
            }
        }
    }

    private void clearActiveBoost(Player player, BoostState state, boolean silent) {
        String activeKey = state.activeBoostKey();
        if (activeKey == null) {
            return;
        }
        String region = WorldGuardHelper.getHighestPriorityRegion(player);
        BoostDefinition boost = this.config.getEffectiveBoost(activeKey, player.getWorld().getName(), region);
        if (boost != null) {
            BoostEndEvent endEvent = new BoostEndEvent(player, activeKey, boost);
            Bukkit.getPluginManager().callEvent((Event)endEvent);
            if (!endEvent.isCancelled()) {
                for (BoostEffect effect : boost.effects()) {
                    if (effect.type() != null) {
                        player.removePotionEffect(effect.type());
                        continue;
                    }
                    for (CustomBoostEffect custom : this.customEffects.values()) {
                        if (custom == null) continue;
                        custom.remove(player);
                    }
                }
                this.runDisableCommands(player, boost);
                if (!silent && this.config.settings().sendExpiredMessage()) {
                    player.sendMessage(this.messages.message("boost-expired", Placeholder.parsed("boost", activeKey)));
                }
            }
        }
        state.clearActiveBoost();
        this.cancelExpiryTask(player.getUniqueId());
        this.cancelActionbarTask(player.getUniqueId());
    }

    private void scheduleExpiry(Player player, BoostDefinition boost, long endTimestamp) {
        this.cancelExpiryTask(player.getUniqueId());
        long delayTicks = Math.max(1L, (endTimestamp - System.currentTimeMillis()) / 50L);
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            BoostState state = this.states.get(player.getUniqueId());
            if (state == null || state.activeBoostKey() == null) {
                return;
            }
            if (!boost.key().equalsIgnoreCase(state.activeBoostKey())) {
                return;
            }
            this.clearActiveBoost(player, state, false);
            this.saveStates();
        }, delayTicks);
        this.expiryTasks.put(player.getUniqueId(), task);
    }

    private void scheduleActionbar(Player player, BoostDefinition boost) {
        if (!this.messages.actionbarEnabled()) {
            return;
        }
        this.cancelActionbarTask(player.getUniqueId());
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            BoostState state = this.states.get(player.getUniqueId());
            if (state == null || state.activeBoostKey() == null) {
                this.cancelActionbarTask(player.getUniqueId());
                return;
            }
            long remaining = Math.max(0L, (state.endTimestamp() - System.currentTimeMillis()) / 1000L);
            if (remaining <= 0L) {
                this.cancelActionbarTask(player.getUniqueId());
                return;
            }
            this.sendActionBar(player, this.messages.actionbar(boost.key(), remaining));
        }, 20L, 20L);
        this.actionbarTasks.put(player.getUniqueId(), task);
    }

    private void cancelExpiryTask(UUID uuid) {
        BukkitTask task = this.expiryTasks.remove(uuid);
        if (task != null) {
            task.cancel();
        }
    }

    private void cancelActionbarTask(UUID uuid) {
        BukkitTask task = this.actionbarTasks.remove(uuid);
        if (task != null) {
            task.cancel();
        }
    }

    private String formatCost(double cost) {
        if (cost == Math.floor(cost)) {
            return String.valueOf((int)cost);
        }
        return String.format(Locale.US, "%.2f", cost);
    }

    private String cooldownKey(String boostKey) {
        if (boostKey == null) {
            return GLOBAL_COOLDOWN_KEY;
        }
        if (this.config.settings().cooldownPerBoostType()) {
            return boostKey.toLowerCase(Locale.ROOT);
        }
        return GLOBAL_COOLDOWN_KEY;
    }

    private void sendActionBar(Player player, String message) {
        if (message == null || message.isBlank()) {
            return;
        }
        try {
            Method method = player.getClass().getMethod("sendActionBar", String.class);
            method.invoke((Object)player, message);
            return;
        }
        catch (NoSuchMethodException method) {
        }
        catch (ReflectiveOperationException ex) {
            this.logger.fine("Failed to use sendActionBar(String): " + ex.getMessage());
        }
        try {
            Class<?> chatMessageType = Class.forName("net.md_5.bungee.api.ChatMessageType");
            Class<?> baseComponent = Class.forName("net.md_5.bungee.api.chat.BaseComponent");
            Class<?> textComponent = Class.forName("net.md_5.bungee.api.chat.TextComponent");
            Object actionBar = Enum.valueOf(chatMessageType, "ACTION_BAR");
            Object component = textComponent.getConstructor(String.class).newInstance(message);
            Object spigot = player.getClass().getMethod("spigot", new Class[0]).invoke((Object)player, new Object[0]);
            Method sendMessage = spigot.getClass().getMethod("sendMessage", chatMessageType, Array.newInstance(baseComponent, 0).getClass());
            Object array = Array.newInstance(baseComponent, 1);
            Array.set(array, 0, component);
            sendMessage.invoke(spigot, actionBar, array);
        }
        catch (ReflectiveOperationException ex) {
            player.sendMessage(message);
        }
    }

    private void runEnableCommands(Player player, BoostDefinition boost) {
        this.runCommands(player, boost, boost.commands().enable());
        this.runCommands(player, boost, boost.commands().toggle());
    }

    private void runDisableCommands(Player player, BoostDefinition boost) {
        this.runCommands(player, boost, boost.commands().disable());
        this.runCommands(player, boost, boost.commands().toggle());
    }

    private void runCommands(Player player, BoostDefinition boost, List<String> commands) {
        if (commands == null || commands.isEmpty()) {
            return;
        }
        for (String command : commands) {
            if (command == null || command.isBlank()) continue;
            String parsed = command.replace("{player}", player.getName()).replace("{displayname}", player.getDisplayName()).replace("{boost}", boost.key());
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)parsed);
        }
    }

    public static enum ActivationSource {
        COMMAND,
        GUI,
        TOKEN;

    }
}

