/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezboost;

import com.skyblockexp.ezboost.api.EzBoostAPI;
import com.skyblockexp.ezboost.boost.BoostManager;
import com.skyblockexp.ezboost.command.BoostCommand;
import com.skyblockexp.ezboost.command.EzBoostCommand;
import com.skyblockexp.ezboost.config.EzBoostConfig;
import com.skyblockexp.ezboost.config.Messages;
import com.skyblockexp.ezboost.economy.EconomyService;
import com.skyblockexp.ezboost.gui.BoostGui;
import com.skyblockexp.ezboost.gui.BoostTokenFactory;
import com.skyblockexp.ezboost.libs.org.bstats.bukkit.Metrics;
import com.skyblockexp.ezboost.listener.BoostGuiListener;
import com.skyblockexp.ezboost.listener.BoostPlayerListener;
import com.skyblockexp.ezboost.listener.BoostTokenListener;
import com.skyblockexp.ezboost.listener.EconomyServiceListener;
import com.skyblockexp.ezboost.storage.BoostStorage;
import com.skyblockexp.ezboost.update.SpigotUpdateChecker;
import java.io.File;
import java.util.Objects;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class EzBoostPlugin
extends JavaPlugin {
    private static final int BSTATS_PLUGIN_ID = 28496;
    private static final int SPIGOT_RESOURCE_ID = 131030;
    private EzBoostConfig config;
    private Messages messages;
    private EconomyService economyService;
    private BoostStorage storage;
    private BoostManager boostManager;
    private BoostGui boostGui;
    private BoostTokenFactory tokenFactory;

    public void onEnable() {
        this.ensureResource("messages.yml");
        this.ensureDataFile();
        this.config = new EzBoostConfig(this);
        this.messages = new Messages(this);
        this.economyService = new EconomyService();
        this.economyService.setup(this.config.economySettings());
        this.storage = new BoostStorage(this);
        this.boostManager = new BoostManager(this, this.config, this.messages, this.economyService, this.storage);
        this.boostManager.loadStates();
        EzBoostAPI.init(this.boostManager);
        this.boostGui = new BoostGui(this, this.boostManager, this.config.guiSettings());
        this.tokenFactory = new BoostTokenFactory(this);
        this.registerCommands();
        this.registerListeners();
        this.initializeMetrics();
        new SpigotUpdateChecker(this, 131030).checkForUpdates();
        this.getLogger().info("EzBoost plugin has been enabled.");
    }

    public void onDisable() {
        if (this.boostManager != null) {
            this.boostManager.saveStates();
        }
        HandlerList.unregisterAll((Plugin)this);
        this.getLogger().info("EzBoost plugin has been disabled.");
    }

    public void reloadPlugin() {
        this.config.reload();
        this.messages.reload();
        this.economyService.setup(this.config.economySettings());
        this.boostManager.reload(this.config, this.messages, this.economyService);
        this.boostGui.reload(this.config.guiSettings());
    }

    private void registerCommands() {
        BoostCommand boostCommand = new BoostCommand(this.boostManager, this.boostGui, this.messages);
        PluginCommand boost = this.getCommand("boost");
        if (boost != null) {
            boost.setExecutor((CommandExecutor)boostCommand);
            boost.setTabCompleter((TabCompleter)boostCommand);
        }
        EzBoostCommand ezBoostCommand = new EzBoostCommand(this.boostManager, this.messages, this.tokenFactory, this::reloadPlugin);
        PluginCommand ezboost = this.getCommand("ezboost");
        if (ezboost != null) {
            ezboost.setExecutor((CommandExecutor)ezBoostCommand);
            ezboost.setTabCompleter((TabCompleter)ezBoostCommand);
        }
    }

    private void registerListeners() {
        Objects.requireNonNull(this.getServer().getPluginManager()).registerEvents((Listener)new BoostGuiListener(this.boostGui, this.boostManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BoostTokenListener(this.boostManager, this.tokenFactory), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BoostPlayerListener(this.boostManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EconomyServiceListener(this.config, this.economyService, this.getLogger()), (Plugin)this);
    }

    private void ensureResource(String name) {
        File file = new File(this.getDataFolder(), name);
        if (!file.exists()) {
            this.saveResource(name, false);
        }
    }

    private void ensureDataFile() {
        File file = new File(this.getDataFolder(), "data.yml");
        if (!file.exists()) {
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (Exception ex) {
                this.getLogger().warning("Failed to create data.yml: " + ex.getMessage());
            }
        }
    }

    private void initializeMetrics() {
        try {
            new Metrics(this, 28496);
        }
        catch (Exception ex) {
            this.getLogger().warning("Failed to start bStats metrics: " + ex.getMessage());
        }
    }
}

