/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezbanners.sync;

import com.skyblockexp.ezbanners.EzBannersPlugin;
import com.skyblockexp.ezbanners.config.EzBannersConfig;
import com.skyblockexp.ezbanners.domain.SyncPayload;
import com.skyblockexp.ezbanners.http.ApiClient;
import com.skyblockexp.ezbanners.metrics.ServerDataCollector;
import com.skyblockexp.ezbanners.sync.SyncExecutor;
import com.skyblockexp.ezbanners.sync.SyncScheduler;

public class SyncService {
    private final EzBannersPlugin plugin;
    private final SyncScheduler scheduler;
    private final SyncExecutor executor;
    private EzBannersConfig config;
    private ServerDataCollector dataCollector;

    public SyncService(EzBannersPlugin plugin, EzBannersConfig config, ServerDataCollector dataCollector) {
        this.plugin = plugin;
        this.config = config;
        this.dataCollector = dataCollector;
        this.scheduler = new SyncScheduler(plugin, config);
        this.executor = new SyncExecutor(plugin, config, dataCollector);
    }

    public void start() {
        if (this.scheduler.isRunning()) {
            this.plugin.debug("SyncService already running");
            return;
        }
        this.plugin.debug("Starting SyncService");
        this.scheduler.start(this::performSync);
    }

    public void stop() {
        this.plugin.debug("Stopping SyncService");
        this.scheduler.stop();
    }

    public void reload(EzBannersConfig config, ServerDataCollector dataCollector) {
        this.plugin.debug("Reloading SyncService");
        this.config = config;
        this.dataCollector = dataCollector;
        this.scheduler.updateConfig(config);
        this.executor.updateConfig(config, dataCollector);
        this.stop();
        this.start();
    }

    private void performSync() {
        this.plugin.debug("Performing sync");
        try {
            SyncPayload payload = this.executor.buildPayload();
            ApiClient.ApiResponse response = this.executor.executeSync(payload);
            if (response.isSuccess()) {
                this.plugin.debug("Sync successful: " + response.getStatusCode());
                this.scheduler.onSyncSuccess(this::performSync);
            } else {
                this.plugin.debug("Sync failed: " + response.getStatusCode() + " - " + response.getMessage());
                this.scheduler.onSyncFailure(this::performSync);
            }
        }
        catch (Exception ex) {
            this.plugin.getLogger().warning("[EzBanners] Sync error: " + ex.getMessage());
            this.scheduler.onSyncFailure(this::performSync);
        }
    }

    public SyncScheduler getScheduler() {
        return this.scheduler;
    }

    public SyncExecutor getExecutor() {
        return this.executor;
    }
}

