/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezbanners.sync;

import com.skyblockexp.ezbanners.EzBannersPlugin;
import com.skyblockexp.ezbanners.config.EzBannersConfig;
import java.util.Random;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class SyncScheduler {
    private final EzBannersPlugin plugin;
    private final Random random;
    private EzBannersConfig config;
    private BukkitTask scheduledTask;
    private int failureCount;
    private boolean running;

    public SyncScheduler(EzBannersPlugin plugin, EzBannersConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.random = new Random();
        this.failureCount = 0;
        this.running = false;
    }

    public void start(Runnable syncTask) {
        if (this.running) {
            this.plugin.debug("SyncScheduler already running");
            return;
        }
        this.running = true;
        this.failureCount = 0;
        this.scheduleNext(0L, syncTask);
    }

    public void stop() {
        this.running = false;
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
        }
        this.plugin.debug("SyncScheduler stopped");
    }

    public void onSyncSuccess(Runnable syncTask) {
        this.failureCount = 0;
        this.plugin.debug("Sync succeeded, resetting failure count");
        this.scheduleNext(this.config.getSyncIntervalSeconds(), syncTask);
    }

    public void onSyncFailure(Runnable syncTask) {
        ++this.failureCount;
        int backoff = this.calculateBackoff();
        this.plugin.getLogger().warning("[EzBanners] Sync failed, retrying in " + backoff + "s (failure count: " + this.failureCount + ")");
        this.scheduleNext(backoff, syncTask);
    }

    public void updateConfig(EzBannersConfig config) {
        this.config = config;
    }

    private int calculateBackoff() {
        int baseBackoff = (int)Math.min((double)this.config.getMaxBackoffSeconds(), (double)this.config.getSyncIntervalSeconds() * Math.pow(2.0, Math.min(this.failureCount, 10)));
        int jitter = this.random.nextInt(baseBackoff / 4 + 1);
        return Math.min(baseBackoff + jitter, this.config.getMaxBackoffSeconds());
    }

    private void scheduleNext(long delaySeconds, final Runnable syncTask) {
        if (!this.running) {
            return;
        }
        long ticks = Math.max(1L, delaySeconds * 20L);
        this.plugin.debug("Scheduling next sync in " + delaySeconds + "s (" + ticks + " ticks)");
        this.scheduledTask = new BukkitRunnable(){

            public void run() {
                if (SyncScheduler.this.running) {
                    syncTask.run();
                }
            }
        }.runTaskLaterAsynchronously((Plugin)this.plugin, ticks);
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getFailureCount() {
        return this.failureCount;
    }
}

