/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezbanners.lifecycle;

import com.skyblockexp.ezbanners.EzBannersPlugin;
import com.skyblockexp.ezbanners.api.EzBannersApi;
import com.skyblockexp.ezbanners.config.EzBannersConfig;
import com.skyblockexp.ezbanners.http.ApiClient;
import com.skyblockexp.ezbanners.metrics.ServerDataCollector;
import com.skyblockexp.ezbanners.sync.SyncService;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class PluginLifecycle {
    private final EzBannersPlugin plugin;
    private EzBannersConfig config;
    private ServerDataCollector dataCollector;
    private SyncService syncService;
    private EzBannersApi api;
    private BukkitTask usageStatsTask;
    private final long serverStartMillis;

    public PluginLifecycle(EzBannersPlugin plugin) {
        this.plugin = plugin;
        this.serverStartMillis = System.currentTimeMillis();
    }

    public void startup() {
        this.plugin.getLogger().info("[EzBanners] Starting up...");
        this.plugin.saveDefaultConfig();
        this.ensureServerUuid();
        this.config = new EzBannersConfig(this.plugin);
        if (!this.config.isValid()) {
            this.plugin.getLogger().severe("[EzBanners] Configuration validation failed. Plugin may not work correctly.");
        }
        this.dataCollector = new ServerDataCollector(this.plugin, this.config, this.serverStartMillis);
        this.syncService = new SyncService(this.plugin, this.config, this.dataCollector);
        this.api = new EzBannersApi(this.plugin);
        this.startUsageStatsReporting();
        if (this.config.isWebsiteSyncEnabled()) {
            this.plugin.getLogger().info("[EzBanners] Starting sync service");
            this.syncService.start();
        } else {
            this.plugin.getLogger().info("[EzBanners] Website sync is disabled");
        }
        this.plugin.getLogger().info("[EzBanners] Startup complete");
    }

    public void shutdown() {
        this.plugin.getLogger().info("[EzBanners] Shutting down...");
        if (this.syncService != null) {
            this.syncService.stop();
        }
        if (this.usageStatsTask != null && !this.usageStatsTask.isCancelled()) {
            this.usageStatsTask.cancel();
            this.usageStatsTask = null;
        }
        if (this.api != null) {
            this.api.stopAutoStatsPush();
        }
        this.syncService = null;
        this.dataCollector = null;
        this.config = null;
        this.api = null;
        this.plugin.getLogger().info("[EzBanners] Shutdown complete");
    }

    public void reload() {
        this.plugin.getLogger().info("[EzBanners] Reloading configuration...");
        this.plugin.reloadConfig();
        this.ensureServerUuid();
        this.config = new EzBannersConfig(this.plugin);
        if (!this.config.isValid()) {
            this.plugin.getLogger().warning("[EzBanners] Configuration validation failed after reload");
        }
        if (this.dataCollector != null) {
            this.dataCollector.refreshConfig(this.config, this.serverStartMillis);
        }
        if (this.syncService != null) {
            this.syncService.reload(this.config, this.dataCollector);
        }
        this.plugin.getLogger().info("[EzBanners] Reload complete");
    }

    private void ensureServerUuid() {
        String uuid = this.plugin.getConfig().getString("server.uuid", "");
        if (uuid == null || uuid.trim().isEmpty()) {
            String generated = UUID.randomUUID().toString();
            this.plugin.getConfig().set("server.uuid", (Object)generated);
            this.plugin.saveConfig();
            this.plugin.getLogger().info("[EzBanners] Generated server UUID: " + generated);
        }
    }

    private void startUsageStatsReporting() {
        String ezbannersPluginId = "ca69c7a3-50e0-45fe-b0b6-189b397c86d4";
        ApiClient apiClient = new ApiClient(this.plugin);
        this.usageStatsTask = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            try {
                String pluginName = this.plugin.getDescription().getName();
                String pluginVersion = this.plugin.getDescription().getVersion();
                int playerCount = this.plugin.getServer().getOnlinePlayers().size();
                apiClient.postPluginUsageStats(ezbannersPluginId, pluginName, pluginVersion, 1, playerCount);
                this.plugin.debug("Usage stats sent successfully");
            }
            catch (Exception ex) {
                this.plugin.debug("Usage stats push failed: " + ex.getMessage());
            }
        }, 0L, 6000L);
    }

    public EzBannersConfig getConfig() {
        return this.config;
    }

    public ServerDataCollector getDataCollector() {
        return this.dataCollector;
    }

    public SyncService getSyncService() {
        return this.syncService;
    }

    public EzBannersApi getApi() {
        return this.api;
    }
}

