/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezbanners.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class EzBannersConfig {
    private final JavaPlugin plugin;
    private final FileConfiguration config;
    private final String apiEndpoint;
    private final String apiToken;
    private final String pluginEndpoint;
    private final String pluginUuid;
    private final String pluginToken;
    private final String serverUuid;
    private final int syncIntervalSeconds;
    private final int maxBackoffSeconds;
    private final boolean debugEnabled;
    private final boolean metricsEnabled;
    private final boolean placeholdersEnabled;
    private final boolean websiteSyncEnabled;
    private final Set<String> enabledFields;
    private final Map<String, String> placeholderMappings;
    private boolean valid = true;

    public EzBannersConfig(JavaPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.apiEndpoint = this.config.getString("api.endpoint", "");
        this.apiToken = this.config.getString("api.token", "");
        this.pluginEndpoint = this.config.getString("plugin.endpoint", "");
        this.pluginUuid = this.config.getString("plugin.uuid", "");
        this.pluginToken = this.config.getString("plugin.token", "");
        this.serverUuid = this.config.getString("server.uuid", "");
        this.syncIntervalSeconds = Math.max(5, this.config.getInt("sync.interval", 30));
        this.maxBackoffSeconds = Math.max(this.syncIntervalSeconds, this.config.getInt("sync.max-backoff", 300));
        this.debugEnabled = this.config.getBoolean("debug.enabled", false);
        this.metricsEnabled = this.config.getBoolean("features.metrics.enabled", true);
        this.placeholdersEnabled = this.config.getBoolean("features.placeholders.enabled", true);
        this.websiteSyncEnabled = this.config.getBoolean("features.website-sync.enabled", true);
        this.enabledFields = this.readFields();
        this.placeholderMappings = this.readPlaceholderMappings();
        this.validate();
    }

    private Set<String> readFields() {
        List list = this.config.getStringList("enabled.data.fields");
        if (list == null || list.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> fields = new HashSet<String>();
        for (String entry : list) {
            if (entry == null) continue;
            fields.add(entry.toLowerCase());
        }
        return fields;
    }

    private Map<String, String> readPlaceholderMappings() {
        String mappingsPath = "placeholderapi.mappings";
        if (!this.config.isConfigurationSection(mappingsPath)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String key : this.config.getConfigurationSection(mappingsPath).getKeys(false)) {
            String value = this.config.getString(mappingsPath + "." + key, "");
            if (value != null && !value.trim().isEmpty()) {
                map.put(key, value);
                continue;
            }
            this.plugin.getLogger().warning("[EzBanners] Empty placeholder mapping for key: " + key);
        }
        return map;
    }

    private void validate() {
        if (this.serverUuid == null || this.serverUuid.trim().isEmpty()) {
            this.plugin.getLogger().severe("[EzBanners] Missing required config: server.uuid");
            this.valid = false;
        }
        if (this.apiEndpoint == null || this.apiEndpoint.trim().isEmpty()) {
            this.plugin.getLogger().warning("[EzBanners] Missing config: api.endpoint - sync will not work until configured");
        }
        if (this.apiToken == null || this.apiToken.trim().isEmpty()) {
            this.plugin.getLogger().warning("[EzBanners] Missing config: api.token - use /ezbanners link <token> to configure");
        }
        if (this.syncIntervalSeconds < 5) {
            this.plugin.getLogger().warning("[EzBanners] Sync interval too low, using minimum of 5 seconds");
        }
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public String getPluginEndpoint() {
        return this.pluginEndpoint;
    }

    public String getPluginUuid() {
        return this.pluginUuid;
    }

    public String getPluginToken() {
        return this.pluginToken;
    }

    public String getServerUuid() {
        return this.serverUuid;
    }

    public int getSyncIntervalSeconds() {
        return this.syncIntervalSeconds;
    }

    public int getMaxBackoffSeconds() {
        return this.maxBackoffSeconds;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public boolean isPlaceholdersEnabled() {
        return this.placeholdersEnabled;
    }

    public boolean isWebsiteSyncEnabled() {
        return this.websiteSyncEnabled;
    }

    public boolean isFieldEnabled(String field) {
        return this.enabledFields.contains(field.toLowerCase());
    }

    public Map<String, String> getPlaceholderMappings() {
        return Collections.unmodifiableMap(this.placeholderMappings);
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }
}

