/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezbanners.command;

import com.skyblockexp.ezbanners.EzBannersPlugin;
import com.skyblockexp.ezbanners.config.EzBannersConfig;
import com.skyblockexp.ezbanners.sync.SyncScheduler;
import com.skyblockexp.ezbanners.sync.SyncService;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class StatusCommand
implements CommandExecutor {
    private final EzBannersPlugin plugin;

    public StatusCommand(EzBannersPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("ezbanners.status")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        EzBannersConfig config = this.plugin.getEzBannersConfig();
        if (config == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "EzBanners configuration not loaded");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== EzBanners Status ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Version: " + String.valueOf(ChatColor.WHITE) + this.plugin.getDescription().getVersion());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Config Valid: " + (config.isValid() ? String.valueOf(ChatColor.GREEN) + "Yes" : String.valueOf(ChatColor.RED) + "No"));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Server UUID: " + String.valueOf(ChatColor.WHITE) + config.getServerUuid());
        sender.sendMessage("");
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "API Configuration:");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Endpoint: " + String.valueOf(ChatColor.WHITE) + config.getApiEndpoint());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Token Configured: " + (this.isTokenConfigured(config.getApiToken()) ? String.valueOf(ChatColor.GREEN) + "Yes" : String.valueOf(ChatColor.RED) + "No"));
        sender.sendMessage("");
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Features:");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Metrics: " + this.getStatusColor(config.isMetricsEnabled()) + config.isMetricsEnabled());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Placeholders: " + this.getStatusColor(config.isPlaceholdersEnabled()) + config.isPlaceholdersEnabled());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Website Sync: " + this.getStatusColor(config.isWebsiteSyncEnabled()) + config.isWebsiteSyncEnabled());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Debug: " + this.getStatusColor(config.isDebugEnabled()) + config.isDebugEnabled());
        SyncService syncService = this.plugin.getLifecycle().getSyncService();
        if (syncService != null) {
            SyncScheduler scheduler = syncService.getScheduler();
            sender.sendMessage("");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Sync Service:");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Running: " + this.getStatusColor(scheduler.isRunning()) + scheduler.isRunning());
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Failure Count: " + String.valueOf(ChatColor.WHITE) + scheduler.getFailureCount());
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Sync Interval: " + String.valueOf(ChatColor.WHITE) + config.getSyncIntervalSeconds() + "s");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Max Backoff: " + String.valueOf(ChatColor.WHITE) + config.getMaxBackoffSeconds() + "s");
        }
        return true;
    }

    private boolean isTokenConfigured(String token) {
        return token != null && !token.trim().isEmpty();
    }

    private String getStatusColor(boolean enabled) {
        return enabled ? ChatColor.GREEN.toString() : ChatColor.RED.toString();
    }
}

