/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezbanners;

import com.skyblockexp.ezbanners.api.EzBannersApi;
import com.skyblockexp.ezbanners.command.LinkCommand;
import com.skyblockexp.ezbanners.command.StatusCommand;
import com.skyblockexp.ezbanners.config.EzBannersConfig;
import com.skyblockexp.ezbanners.lifecycle.PluginLifecycle;
import java.util.logging.Level;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.java.JavaPlugin;

public class EzBannersPlugin
extends JavaPlugin {
    private static EzBannersPlugin instance;
    private PluginLifecycle lifecycle;

    public void onEnable() {
        instance = this;
        this.lifecycle = new PluginLifecycle(this);
        this.lifecycle.startup();
        this.registerCommands();
    }

    public void onDisable() {
        if (this.lifecycle != null) {
            this.lifecycle.shutdown();
        }
        instance = null;
        this.getLogger().info("[EzBanners] Disabled cleanly.");
    }

    private void registerCommands() {
        PluginCommand command = this.getCommand("ezbanners");
        if (command != null) {
            command.setExecutor((sender, cmd, label, args) -> {
                if (args.length > 0) {
                    if (args[0].equalsIgnoreCase("reload")) {
                        if (!sender.hasPermission("ezbanners.reload")) {
                            sender.sendMessage("\u00a7cYou do not have permission to reload EzBanners.");
                            return true;
                        }
                        this.lifecycle.reload();
                        sender.sendMessage("\u00a7aEzBanners configuration reloaded.");
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("status")) {
                        return new StatusCommand(this).onCommand(sender, cmd, label, args);
                    }
                }
                return new LinkCommand(this).onCommand(sender, cmd, label, args);
            });
        } else {
            this.getLogger().warning("[EzBanners] Command not registered. Check plugin.yml.");
        }
    }

    public static EzBannersPlugin getInstance() {
        return instance;
    }

    public PluginLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public EzBannersConfig getEzBannersConfig() {
        return this.lifecycle != null ? this.lifecycle.getConfig() : null;
    }

    public EzBannersApi getApi() {
        return this.lifecycle != null ? this.lifecycle.getApi() : null;
    }

    public void reloadEzBannersConfig() {
        if (this.lifecycle != null) {
            this.lifecycle.reload();
        }
    }

    public void debug(String message) {
        EzBannersConfig config = this.getEzBannersConfig();
        if (config != null && config.isDebugEnabled()) {
            this.getLogger().log(Level.INFO, "[EzBanners][Debug] " + message);
        }
    }
}

