/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezbanners.util;

import com.skyblockexp.ezbanners.EzBannersPlugin;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public final class ServerUtil {
    private ServerUtil() {
    }

    public static String getServerName() {
        try {
            String name = Bukkit.getServer().getName();
            if (name != null && !name.trim().isEmpty()) {
                return name;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "UnknownServer";
    }

    public static int getOnlinePlayerCount() {
        Object players = ServerUtil.getOnlinePlayersRaw();
        if (players instanceof Iterable) {
            int count = 0;
            for (Object ignored : (Iterable)players) {
                ++count;
            }
            return count;
        }
        if (players != null && players.getClass().isArray()) {
            return Array.getLength(players);
        }
        return 0;
    }

    public static OfflinePlayer getFirstOnlinePlayer() {
        Object player;
        Object players = ServerUtil.getOnlinePlayersRaw();
        if (players instanceof Iterable) {
            for (Object player2 : (Iterable)players) {
                if (!(player2 instanceof Player)) continue;
                return (Player)player2;
            }
        }
        if (players != null && players.getClass().isArray() && Array.getLength(players) > 0 && (player = Array.get(players, 0)) instanceof Player) {
            return (Player)player;
        }
        return null;
    }

    private static Object getOnlinePlayersRaw() {
        try {
            Method method = Bukkit.class.getMethod("getOnlinePlayers", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static double[] getTps() {
        try {
            Method method = Bukkit.getServer().getClass().getMethod("getTPS", new Class[0]);
            Object result = method.invoke((Object)Bukkit.getServer(), new Object[0]);
            if (result instanceof double[]) {
                return (double[])result;
            }
        }
        catch (Throwable method) {
            // empty catch block
        }
        try {
            Method getServer = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]);
            Object mcServer = getServer.invoke((Object)Bukkit.getServer(), new Object[0]);
            Field recentTps = mcServer.getClass().getField("recentTps");
            Object value = recentTps.get(mcServer);
            if (value instanceof double[]) {
                return (double[])value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static double round(double value) {
        return (double)Math.round(value * 100.0) / 100.0;
    }

    public static Map<String, String> resolvePlaceholders(EzBannersPlugin plugin, Map<String, String> mappings, OfflinePlayer context) {
        if (mappings == null || mappings.isEmpty()) {
            return Collections.emptyMap();
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> resolved = new LinkedHashMap<String, String>();
        try {
            Class<?> placeholderApiClass = Class.forName("me.clip.placeholderapi.PlaceholderAPI");
            Method setPlaceholders = placeholderApiClass.getMethod("setPlaceholders", OfflinePlayer.class, String.class);
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                String placeholder = entry.getValue();
                if (placeholder == null || placeholder.trim().isEmpty()) continue;
                try {
                    Object value = setPlaceholders.invoke(null, context, placeholder);
                    resolved.put(entry.getKey(), value == null ? "" : value.toString());
                }
                catch (Exception ex) {
                    plugin.debug("Placeholder resolution failed for " + entry.getKey() + ": " + ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            plugin.debug("PlaceholderAPI not available: " + ex.getMessage());
        }
        return resolved;
    }
}

