/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezbanners.metrics;

import com.skyblockexp.ezbanners.EzBannersPlugin;
import com.skyblockexp.ezbanners.config.EzBannersConfig;
import com.skyblockexp.ezbanners.util.ServerUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class ServerDataCollector {
    private EzBannersPlugin plugin;
    private EzBannersConfig config;
    private long serverStartMillis;

    public ServerDataCollector(EzBannersPlugin plugin, EzBannersConfig config, long serverStartMillis) {
        this.plugin = plugin;
        this.config = config;
        this.serverStartMillis = serverStartMillis;
    }

    public void refreshConfig(EzBannersConfig config, long serverStartMillis) {
        this.config = config;
        this.serverStartMillis = serverStartMillis;
    }

    public Map<String, Object> collectData() {
        Map<String, String> placeholders;
        double[] tps;
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        if (this.config.isFieldEnabled("server_name")) {
            data.put("server_name", ServerUtil.getServerName());
        }
        if (this.config.isFieldEnabled("online_players")) {
            data.put("online_players", ServerUtil.getOnlinePlayerCount());
        }
        if (this.config.isFieldEnabled("max_players")) {
            data.put("max_players", Bukkit.getMaxPlayers());
        }
        if (this.config.isFieldEnabled("server_version")) {
            data.put("server_version", Bukkit.getVersion());
        }
        if ((this.config.isFieldEnabled("tps_1m") || this.config.isFieldEnabled("tps_5m") || this.config.isFieldEnabled("tps_15m")) && (tps = ServerUtil.getTps()) != null) {
            if (this.config.isFieldEnabled("tps_1m")) {
                data.put("tps_1m", ServerUtil.round(tps[0]));
            }
            if (this.config.isFieldEnabled("tps_5m") && tps.length > 1) {
                data.put("tps_5m", ServerUtil.round(tps[1]));
            }
            if (this.config.isFieldEnabled("tps_15m") && tps.length > 2) {
                data.put("tps_15m", ServerUtil.round(tps[2]));
            }
        }
        if (this.config.isFieldEnabled("uptime")) {
            data.put("uptime", Math.max(0L, System.currentTimeMillis() - this.serverStartMillis));
        }
        if (this.config.isFieldEnabled("motd")) {
            data.put("motd", Bukkit.getMotd());
        }
        if (this.config.isFieldEnabled("whitelist")) {
            data.put("whitelist", Bukkit.hasWhitelist());
        }
        if (this.config.isFieldEnabled("placeholders") && !(placeholders = ServerUtil.resolvePlaceholders(this.plugin, this.config.getPlaceholderMappings(), this.getContextPlayer())).isEmpty()) {
            data.put("placeholders", placeholders);
        }
        return data;
    }

    private OfflinePlayer getContextPlayer() {
        return ServerUtil.getFirstOnlinePlayer();
    }
}

