/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezbanners.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class EzBannersConfig {
    private final JavaPlugin plugin;
    private final FileConfiguration config;
    private final String apiEndpoint;
    private final String apiToken;
    private final String pluginEndpoint;
    private final String pluginUuid;
    private final String pluginToken;
    private final String serverUuid;
    private final int syncIntervalSeconds;
    private final int maxBackoffSeconds;
    private final boolean debugEnabled;
    private final Set<String> enabledFields;
    private final Map<String, String> placeholderMappings;

    public EzBannersConfig(JavaPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.apiEndpoint = this.config.getString("api.endpoint", "");
        this.apiToken = this.config.getString("api.token", "");
        this.pluginEndpoint = this.config.getString("plugin.endpoint", "");
        this.pluginUuid = this.config.getString("plugin.uuid", "");
        this.pluginToken = this.config.getString("plugin.token", "");
        this.serverUuid = this.config.getString("server.uuid", "");
        this.syncIntervalSeconds = Math.max(5, this.config.getInt("sync.interval", 30));
        this.maxBackoffSeconds = Math.max(this.syncIntervalSeconds, this.config.getInt("sync.max-backoff", 300));
        this.debugEnabled = this.config.getBoolean("debug.enabled", false);
        this.enabledFields = this.readFields();
        this.placeholderMappings = this.readPlaceholderMappings();
    }

    private Set<String> readFields() {
        List list = this.config.getStringList("enabled.data.fields");
        if (list == null || list.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> fields = new HashSet<String>();
        for (String entry : list) {
            if (entry == null) continue;
            fields.add(entry.toLowerCase());
        }
        return fields;
    }

    private Map<String, String> readPlaceholderMappings() {
        if (!this.config.isConfigurationSection("placeholderapi.mappings")) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String key : this.config.getConfigurationSection("placeholderapi.mappings").getKeys(false)) {
            String value = this.config.getString("placeholderapi.mappings." + key, "");
            map.put(key, value);
        }
        return map;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public String getPluginEndpoint() {
        return this.pluginEndpoint;
    }

    public String getPluginUuid() {
        return this.pluginUuid;
    }

    public String getPluginToken() {
        return this.pluginToken;
    }

    public String getServerUuid() {
        return this.serverUuid;
    }

    public int getSyncIntervalSeconds() {
        return this.syncIntervalSeconds;
    }

    public int getMaxBackoffSeconds() {
        return this.maxBackoffSeconds;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isFieldEnabled(String field) {
        return this.enabledFields.contains(field.toLowerCase());
    }

    public Map<String, String> getPlaceholderMappings() {
        return Collections.unmodifiableMap(this.placeholderMappings);
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }
}

