/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezbanners.api;

import com.skyblockexp.ezbanners.EzBannersPlugin;
import com.skyblockexp.ezbanners.config.EzBannersConfig;
import com.skyblockexp.ezbanners.http.ApiClient;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EzBannersApi {
    private final EzBannersPlugin plugin;
    private final ApiClient apiClient;
    private BukkitRunnable statsTask;

    public EzBannersApi(EzBannersPlugin plugin) {
        this.plugin = plugin;
        this.apiClient = new ApiClient(plugin);
    }

    public ApiClient.ApiResponse sendPluginStats(String pluginUuid, JavaPlugin sourcePlugin, int serverCount, int playerCount) {
        return this.sendPluginStats(pluginUuid, sourcePlugin, serverCount, playerCount, null, null);
    }

    public ApiClient.ApiResponse sendPluginStats(String pluginUuid, JavaPlugin sourcePlugin, int serverCount, int playerCount, Map<String, Object> extraStats, Map<String, Object> metaOverrides) {
        if (sourcePlugin == null) {
            return new ApiClient.ApiResponse(false, 0, "Missing source plugin");
        }
        if (pluginUuid == null || pluginUuid.trim().isEmpty()) {
            return new ApiClient.ApiResponse(false, 0, "Missing plugin UUID");
        }
        EzBannersConfig config = this.plugin.getEzBannersConfig();
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> pluginInfo = new LinkedHashMap<String, String>();
        PluginDescriptionFile description = sourcePlugin.getDescription();
        pluginInfo.put("name", description.getName());
        pluginInfo.put("version", description.getVersion());
        payload.put("plugin", pluginInfo);
        LinkedHashMap<String, Object> stats = new LinkedHashMap<String, Object>();
        stats.put("servers", Math.max(0, serverCount));
        stats.put("players", Math.max(0, playerCount));
        if (extraStats != null) {
            stats.putAll(extraStats);
        }
        payload.put("stats", stats);
        LinkedHashMap<String, Object> meta = new LinkedHashMap<String, Object>();
        meta.put("server_uuid", config.getServerUuid());
        meta.put("server_name", sourcePlugin.getServer().getName());
        if (metaOverrides != null) {
            meta.putAll(metaOverrides);
        }
        payload.put("meta", meta);
        return this.apiClient.postPluginPayload(config, pluginUuid, payload);
    }

    public void startAutoStatsPush(final String pluginUuid, final JavaPlugin sourcePlugin, int intervalSeconds) {
        if (this.statsTask != null) {
            this.statsTask.cancel();
        }
        this.statsTask = new BukkitRunnable(){

            public void run() {
                int serverCount = 1;
                int playerCount = Bukkit.getOnlinePlayers().size();
                EzBannersApi.this.sendPluginStats(pluginUuid, sourcePlugin, serverCount, playerCount);
            }
        };
        this.statsTask.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, (long)intervalSeconds * 20L);
    }

    public void stopAutoStatsPush() {
        if (this.statsTask != null) {
            this.statsTask.cancel();
            this.statsTask = null;
        }
    }
}

