/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezbanners.util;

import java.util.Collection;
import java.util.Map;

public final class JsonUtil {
    private JsonUtil() {
    }

    public static String toJson(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + JsonUtil.escape((String)value) + "\"";
        }
        if (value instanceof Number || value instanceof Boolean) {
            return String.valueOf(value);
        }
        if (value instanceof Map) {
            return JsonUtil.mapToJson((Map)value);
        }
        if (value instanceof Collection) {
            return JsonUtil.collectionToJson((Collection)value);
        }
        return "\"" + JsonUtil.escape(String.valueOf(value)) + "\"";
    }

    private static String mapToJson(Map<?, ?> map) {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!first) {
                builder.append(',');
            }
            first = false;
            builder.append('\"').append(JsonUtil.escape(String.valueOf(entry.getKey()))).append('\"').append(':');
            builder.append(JsonUtil.toJson(entry.getValue()));
        }
        builder.append('}');
        return builder.toString();
    }

    private static String collectionToJson(Collection<?> collection) {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        boolean first = true;
        for (Object value : collection) {
            if (!first) {
                builder.append(',');
            }
            first = false;
            builder.append(JsonUtil.toJson(value));
        }
        builder.append(']');
        return builder.toString();
    }

    public static String escape(String value) {
        if (value == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\\': {
                    builder.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    builder.append("\\\"");
                    continue block9;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block9;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block9;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block9;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block9;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        builder.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }
}

