/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezbanners.sync;

import com.skyblockexp.ezbanners.EzBannersPlugin;
import com.skyblockexp.ezbanners.config.EzBannersConfig;
import com.skyblockexp.ezbanners.http.ApiClient;
import com.skyblockexp.ezbanners.metrics.ServerDataCollector;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class SyncService {
    private final EzBannersPlugin plugin;
    private EzBannersConfig config;
    private ServerDataCollector dataCollector;
    private final ApiClient apiClient;
    private BukkitTask scheduledTask;
    private int failureCount;
    private boolean running;

    public SyncService(EzBannersPlugin plugin, EzBannersConfig config, ServerDataCollector dataCollector) {
        this.plugin = plugin;
        this.config = config;
        this.dataCollector = dataCollector;
        this.apiClient = new ApiClient(plugin);
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.scheduleNext(0L);
    }

    public void stop() {
        this.running = false;
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
        }
    }

    public void reload(EzBannersConfig config, ServerDataCollector dataCollector) {
        this.config = config;
        this.dataCollector = dataCollector;
        this.stop();
        this.start();
    }

    private void scheduleNext(long delaySeconds) {
        if (!this.running) {
            return;
        }
        long ticks = Math.max(1L, delaySeconds * 20L);
        this.scheduledTask = new BukkitRunnable(){

            public void run() {
                SyncService.this.syncOnce();
            }
        }.runTaskLaterAsynchronously((Plugin)this.plugin, ticks);
    }

    private void syncOnce() {
        if (!this.running) {
            return;
        }
        Map<String, Object> data = this.dataCollector.collectData();
        ApiClient.ApiResponse response = this.apiClient.postPayload(this.config, data);
        if (response.isSuccess()) {
            this.failureCount = 0;
            this.plugin.debug("Synced data successfully. Status: " + response.getStatusCode());
            this.scheduleNext(this.config.getSyncIntervalSeconds());
        } else {
            ++this.failureCount;
            int backoff = (int)Math.min((double)this.config.getMaxBackoffSeconds(), (double)this.config.getSyncIntervalSeconds() * Math.pow(2.0, this.failureCount));
            this.plugin.getLogger().warning("[EzBanners] Sync failed (" + response.getStatusCode() + "): " + response.getMessage());
            this.plugin.debug("Retrying sync in " + backoff + "s.");
            this.scheduleNext(backoff);
        }
    }
}

