/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezbanners.http;

import com.skyblockexp.ezbanners.EzBannersPlugin;
import com.skyblockexp.ezbanners.config.EzBannersConfig;
import com.skyblockexp.ezbanners.util.HmacUtil;
import com.skyblockexp.ezbanners.util.JsonUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;

public class ApiClient {
    private final EzBannersPlugin plugin;

    public ApiClient(EzBannersPlugin plugin) {
        this.plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse postPayload(EzBannersConfig config, Map<String, Object> data) {
        String endpoint = config.getApiEndpoint();
        String token = config.getApiToken();
        if (endpoint == null || endpoint.trim().isEmpty() || token == null || token.trim().isEmpty()) {
            return new ApiResponse(false, 0, "Missing api.endpoint or api.token");
        }
        long timestamp = System.currentTimeMillis();
        String serverUuid = config.getServerUuid();
        LinkedHashMap<String, Map<String, Object>> payload = new LinkedHashMap<String, Map<String, Object>>();
        payload.put("data", data);
        String json = JsonUtil.toJson(payload);
        String signature = HmacUtil.hmacSha256(token, json);
        HttpURLConnection connection = null;
        try {
            URL url = new URL(endpoint);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "EzBanners/1.0");
            connection.setRequestProperty("X-Server-Id", serverUuid);
            connection.setRequestProperty("X-Server-Token", token);
            connection.setRequestProperty("X-Signature", signature);
            connection.setRequestProperty("X-Timestamp", String.valueOf(timestamp));
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(8000);
            connection.setDoOutput(true);
            try (OutputStream outputStream = connection.getOutputStream();){
                outputStream.write(json.getBytes(StandardCharsets.UTF_8));
            }
            int responseCode = connection.getResponseCode();
            String responseMessage = this.readResponse(connection);
            boolean success = responseCode >= 200 && responseCode < 300;
            ApiResponse apiResponse = new ApiResponse(success, responseCode, responseMessage);
            return apiResponse;
        }
        catch (Exception ex) {
            ApiResponse apiResponse = new ApiResponse(false, 0, ex.getMessage());
            return apiResponse;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private String readResponse(HttpURLConnection connection) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getResponseCode() >= 200 && connection.getResponseCode() < 400 ? connection.getInputStream() : connection.getErrorStream(), StandardCharsets.UTF_8));
        try {
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                this.plugin.debug("Failed to read API response: " + ex.getMessage());
                return "";
            }
        }
        reader.close();
        return string;
    }

    public static class ApiResponse {
        private final boolean success;
        private final int statusCode;
        private final String message;

        public ApiResponse(boolean success, int statusCode, String message) {
            this.success = success;
            this.statusCode = statusCode;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

